/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.util;

import fuego.directory.DirectoryRuntimeException;
import fuego.directory.DirectorySession;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import oracle.bpm.lang.DefaultEnvironment;
import oracle.bpm.lang.Literals;
import oracle.bpm.util.Properties;
import oracle.bpm.util.SimpleCrypt;

public class DirectoryEnvironment
extends DefaultEnvironment {
    private DirectorySession dirSession_d;
    public static final String DIRECTORY_URL = "fuego.directory.url";
    public static final String DIRECTORY_ORGANIZATION = "fuego.directory.organization";
    public static final String DIRECTORY_PARTICIPANT = "fuego.directory.participant";
    public static final String DIRECTORY_PASSWORD = "fuego.directory.password";

    public DirectoryEnvironment(String appName, DirectorySession session) {
        super(appName);
        this.dirSession_d = session;
    }

    public DirectoryEnvironment(String name, Properties properties, DirectorySession session) {
        super(name, properties);
        this.dirSession_d = session;
    }

    public DirectoryEnvironment(String name, String propertiesFile, DirectorySession session) throws IOException {
        super(name, propertiesFile);
        this.dirSession_d = session;
    }

    @Deprecated
    public static String encryptValue(String key, String value) {
        try {
            return new String(DirectoryEnvironment.encrypt(key, value.getBytes("UTF-8")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw DirectoryRuntimeException.wrapException(e);
        }
    }

    @Deprecated
    public static String encryptValue(String key, byte[] value) {
        SimpleCrypt encryptor = new SimpleCrypt(key, false);
        byte[] result = new byte[value.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = encryptor.crypt(value[i]);
        }
        try {
            return new String(result, Literals.DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw DirectoryRuntimeException.wrapException(e);
        }
    }

    @Deprecated
    public static byte[] encrypt(String key, String value) {
        try {
            return DirectoryEnvironment.encrypt(key, value.getBytes(Literals.DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw DirectoryRuntimeException.wrapException(e);
        }
    }

    public static byte[] encrypt(String key, byte[] value) {
        SimpleCrypt encryptor = new SimpleCrypt(key, false);
        byte[] result = new byte[value.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = encryptor.crypt(value[i]);
        }
        return result;
    }

    public final DirectorySession getDirectorySession() {
        return this.dirSession_d;
    }

    public final String getOrganization() {
        return this.dirSession_d.getOrganizationName();
    }

    public final String getParticipant() {
        return this.dirSession_d.getParticipant();
    }
}

