/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DefaultDirectoryConfiguration;
import fuego.directory.DirectoryConfigurationManager;
import fuego.directory.ObjectConfiguration;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.xml.XmlWriter;

public class DirectoryLDAPConfiguration {
    private ObjectConfiguration groups;
    private ObjectConfiguration ou;
    private ObjectConfiguration person;
    public static final String MODIFY_TIME_STAMP_SUFFIX = "modifyTimeStamp.suffix";
    public static final String MODIFY_TIME_STAMP_MASK = "modifyTimeStamp.mask";
    public static final String GENERIC_LDAP_CONFIG_URL = "generic.ldap.config.url";
    public static final String ATTRIBUTE_COMPARATOR_SUFIX = ".attributeComparator";
    public static final String FILTER_SUFFIX = ".filter";
    public static Map<String, DirectoryLDAPConfiguration> configurationMap = new HashMap<String, DirectoryLDAPConfiguration>();

    public DirectoryLDAPConfiguration(ObjectConfiguration group, ObjectConfiguration ou, ObjectConfiguration person) {
        this.groups = group;
        this.ou = ou;
        this.person = person;
    }

    public static DirectoryLDAPConfiguration getLDAPConfiguration(String directoryId) {
        return ((DefaultDirectoryConfiguration)DirectoryConfigurationManager.getRuntime(directoryId).getDirectoryConfiguration()).getLdapConfiguration();
    }

    public Map<String, String> getOuNames() {
        return this.ou.getNames();
    }

    public Map<String, String> getGroupsNames() {
        return this.groups.getNames();
    }

    public Map<String, String> getPersonNames() {
        return this.person.getNames();
    }

    public ObjectConfiguration getGroups() {
        return this.groups;
    }

    public ObjectConfiguration getOu() {
        return this.ou;
    }

    public ObjectConfiguration getPerson() {
        return this.person;
    }

    public void writeXML(XmlWriter writer) throws IOException {
        writer.startElement("config");
        this.person.writeXML(writer);
        this.groups.writeXML(writer);
        this.ou.writeXML(writer);
        writer.endElement();
    }
}

