/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DefaultDirectoryConfiguration;
import fuego.directory.DirectoryConfiguration;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.util.FuegoDirectories;
import oracle.bpm.xml.XmlWriter;

public abstract class DirectoryConfigurationResource {
    public static final String PROPERTIES_FILE_EXT = ".dirxml";
    public static final String CONFIG_FILE_NAME = "directory.xml";
    public static final String DEFAULT_ID = "default";
    public static final String ENGINE_PRESET = "engine";
    public static final String DATAWAREHOUSE_PRESET = "datawarehouse";
    public static final String XOBJECTS_PRESET = "xobjects";
    public static final String PORTAL_ANONYMOUS_PRESET = "portal-anonymous";
    public static final String PAPIWS_ANONYMOUS_PRESET = "papiws-anonymous";
    public static final String WRITE_SCHEMA_PROPERTIES = "write.schema.properties.file";

    public abstract File toFile();

    public static DirectoryConfigurationResource createDirectoryConfigurationResourceFromFile(File file) {
        return new FileDirectoryConfigurationResource(file);
    }

    public static DirectoryConfigurationResource createDirectoryConfigurationResourceFromURL(URL url) {
        return new URLDirectoryConfigurationResource(url);
    }

    public static DirectoryConfigurationResource createDirectoryConfigurationResourceFromId(String id) {
        return new IdDirectoryConfigurationResource(id);
    }

    public static DirectoryConfigurationResource createDirectoryConfigurationResourceFromResource(String resource) {
        return new ResourceDirectoryConfigurationResource(resource);
    }

    public static List<String> getResourceIDs() {
        ArrayList<String> idsList = new ArrayList<String>();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String filename = file.getName();
                return filename.endsWith(DirectoryConfigurationResource.PROPERTIES_FILE_EXT);
            }
        };
        for (File file : FuegoDirectories.configDir().listFiles(filter)) {
            String fileName = file.getName();
            idsList.add(fileName.substring(0, fileName.lastIndexOf(46)));
        }
        return idsList;
    }

    public static File getResourceFile(String id) {
        return new File(FuegoDirectories.configDir(), id + PROPERTIES_FILE_EXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectoryConfiguration load() {
        DefaultDirectoryConfiguration directoryConfiguration = null;
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream();
            directoryConfiguration = DefaultDirectoryConfiguration.create(inputStream);
        }
        catch (IOException e) {
            directoryConfiguration = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return directoryConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean store(DirectoryConfiguration directoryConfiguration) {
        boolean stored = false;
        OutputStream outputStream = null;
        try {
            outputStream = this.getOutputStream();
            if (outputStream != null) {
                XmlWriter writer = new XmlWriter(new OutputStreamWriter(outputStream, "UTF-8"), "UTF-8");
                directoryConfiguration.writeXML(writer);
                writer.flush();
                stored = true;
            }
        }
        catch (IOException e) {
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return stored;
    }

    public String toString() {
        return "[empty]";
    }

    public boolean delete() {
        return false;
    }

    public boolean exists() {
        return this.load() != null;
    }

    protected abstract InputStream getInputStream() throws IOException;

    protected abstract OutputStream getOutputStream() throws IOException;

    private static class URLDirectoryConfigurationResource
    extends DirectoryConfigurationResource {
        private URL propertiesURL;

        public URLDirectoryConfigurationResource(URL propertiesURL) {
            this.propertiesURL = propertiesURL;
        }

        @Override
        public String toString() {
            return this.propertiesURL == null ? super.toString() : this.propertiesURL.toString();
        }

        @Override
        public File toFile() {
            return new File(this.propertiesURL.getFile());
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            return this.propertiesURL.openStream();
        }

        protected String getPath() {
            return this.propertiesURL.toString();
        }

        @Override
        protected OutputStream getOutputStream() throws IOException {
            return null;
        }
    }

    private static class ResourceDirectoryConfigurationResource
    extends DirectoryConfigurationResource {
        private String propertiesResource;

        public ResourceDirectoryConfigurationResource(String propertiesResource) {
            this.propertiesResource = propertiesResource;
        }

        @Override
        public String toString() {
            return this.propertiesResource == null ? super.toString() : this.propertiesResource;
        }

        @Override
        public File toFile() {
            throw new UnsupportedOperationException("toFile not supported for resource based directory configurations.");
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            InputStream resourceAsStream = DirectoryConfigurationResource.class.getResourceAsStream(this.propertiesResource);
            if (resourceAsStream == null) {
                resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.propertiesResource);
            }
            return resourceAsStream;
        }

        @Override
        protected OutputStream getOutputStream() throws IOException {
            return null;
        }
    }

    private static class IdDirectoryConfigurationResource
    extends FileDirectoryConfigurationResource {
        private String id;

        public IdDirectoryConfigurationResource(String id) {
            super(IdDirectoryConfigurationResource.getResourceFile(id));
            this.id = id;
        }

        @Override
        public DirectoryConfiguration load() {
            DirectoryConfiguration directoryConfiguration = super.load();
            if (directoryConfiguration == null) {
                directoryConfiguration = DefaultDirectoryConfiguration.create(this.id);
            }
            return directoryConfiguration;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public String toString() {
            String string = super.toString();
            return this.id == null ? string : this.id + ">" + string;
        }
    }

    private static class FileDirectoryConfigurationResource
    extends DirectoryConfigurationResource {
        private File propertiesFileName;

        public FileDirectoryConfigurationResource(File propertiesFileName) {
            this.propertiesFileName = propertiesFileName;
        }

        @Override
        public boolean delete() {
            return this.propertiesFileName.delete();
        }

        @Override
        public boolean exists() {
            return this.propertiesFileName.exists();
        }

        @Override
        public String toString() {
            return this.propertiesFileName == null ? super.toString() : this.propertiesFileName.toString();
        }

        @Override
        public File toFile() {
            return this.propertiesFileName == null ? null : new File(this.propertiesFileName.toString());
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            return new FileInputStream(this.propertiesFileName);
        }

        @Override
        protected OutputStream getOutputStream() throws IOException {
            return new FileOutputStream(this.propertiesFileName);
        }
    }
}

