/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.AbstractDirectoryConfiguration;
import fuego.directory.DirectoryConfigurationLoader;
import fuego.directory.DirectoryConfigurationManager;
import fuego.directory.DirectoryLDAPConfiguration;
import fuego.directory.DirectoryLDAPConfigurationLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import oracle.bpm.configuration.BaseConfiguration;
import oracle.bpm.xml.XmlWriter;

public class DefaultDirectoryConfiguration
extends AbstractDirectoryConfiguration {
    private boolean isLoaded;
    private DirectoryLDAPConfiguration ldapconfiguration;
    public static final String HYBRID_PREFIX = "H_";
    public static final String FUEGO_CONFIGURATION = "fuego";
    public static final String ORGANIZATION_CONFIGURATION = "organization";
    static final String PRESET_TAG = "preset";
    static final String PRESETS_TAG = "presets";
    static final String NAME = "name";
    static final String VALUE = "value";
    static final String PROPERTY_TAG = "property";
    static final String MAIN_TAG = "DirectoryConfiguration";
    static final String ID_TAG = "id";
    static final String FACTORY_TAG = "factory";
    static final String DESCRIPTION_TAG = "description";
    static final String ADIMN_TAG = "admin";
    static final String ADMIN_PASSWORD_TAG = "adminPass";
    static final String ORGANIZATION_TAG = "organization";

    private DefaultDirectoryConfiguration(boolean isLoaded) {
        this(null, isLoaded);
    }

    private DefaultDirectoryConfiguration(String id, boolean isLoaded) {
        super(id);
        this.isLoaded = isLoaded;
    }

    public static DefaultDirectoryConfiguration create(InputStream is) {
        DirectoryConfigurationLoader loader = new DirectoryConfigurationLoader(is);
        loader.parse();
        DefaultDirectoryConfiguration configuration = loader.getConfiguration();
        configuration.isLoaded = true;
        return configuration;
    }

    public static DefaultDirectoryConfiguration create(String id) {
        return new DefaultDirectoryConfiguration(id, false);
    }

    public static String createHybridFactoryName(String organizationFactoryName) {
        return HYBRID_PREFIX + organizationFactoryName;
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public void setPreset(String preset, Hashtable<String, String> properties) {
    }

    @Override
    public void setPresets(Hashtable<String, Hashtable<String, String>> presets) {
    }

    @Override
    public Hashtable<String, String> getPreset(String preset) {
        return null;
    }

    @Override
    public String getConfigType() {
        String result = null;
        BaseConfiguration fuegoConfig = this.getOrganizationConfiguration();
        if (fuegoConfig != null) {
            String organizationFactoryName = fuegoConfig.getConfigType().getName();
            result = this.isHybrid() ? DefaultDirectoryConfiguration.createHybridFactoryName(organizationFactoryName) : organizationFactoryName;
        }
        return result;
    }

    public void loadLdapConfiguration(String url) {
        DirectoryLDAPConfigurationLoader loader = new DirectoryLDAPConfigurationLoader();
        this.ldapconfiguration = loader.buildCustomConfiguration(url);
    }

    public void setLdapConfiguration(DirectoryLDAPConfiguration ldapconfiguration) {
        this.ldapconfiguration = ldapconfiguration;
    }

    public DirectoryLDAPConfiguration getLdapConfiguration() {
        return this.ldapconfiguration;
    }

    @Override
    public String getConnectorProperty(String key) {
        String result = null;
        BaseConfiguration defaultConfiguration = this.getFuegoConfiguration();
        if (defaultConfiguration != null && (result = (String)defaultConfiguration.getProperties().get(key)) == null && this.isHybrid()) {
            result = (String)this.getOrganizationConfiguration().getProperties().get(key);
        }
        return result;
    }

    @Override
    public void writeXML(XmlWriter writer) throws IOException {
        String path;
        if (this.isHybrid() && (path = this.getOrganizationConfiguration().getProperties().getProperty("ldap.directory.propery")) != null) {
            this.loadLdapConfiguration(path);
        }
        writer.startDocument();
        writer.startElement(MAIN_TAG);
        writer.printValuedElement(ID_TAG, this.getId());
        writer.printValuedElement(DESCRIPTION_TAG, this.getDescription());
        writer.printValuedElement(ADIMN_TAG, this.getAdmin());
        writer.printValuedElement(ADMIN_PASSWORD_TAG, this.getAdminScrambledPassword());
        this.writePresets(writer);
        this.getConnectorsConfigurations().writeXML(writer);
        if (this.ldapconfiguration != null) {
            this.ldapconfiguration.writeXML(writer);
        }
        writer.endElement();
    }

    @Override
    public BaseConfiguration getOrganizationConfiguration() {
        return this.isHybrid() ? this.getConnectorsConfigurations().getEntry(DirectoryConfigurationManager.getDirectoryOrganizationConfigurationName()) : this.getFuegoConfiguration();
    }

    @Override
    public BaseConfiguration getFuegoConfiguration() {
        return this.getConnectorsConfigurations().getEntry(DirectoryConfigurationManager.getDirectoryFuegoConfigurationName());
    }

    @Override
    public boolean isHybrid() {
        return this.getConnectorsConfigurations().getEntry(DirectoryConfigurationManager.getDirectoryOrganizationConfigurationName()) != null && this.getFuegoConfiguration() != null;
    }

    static DefaultDirectoryConfiguration createDirectoryConfiguration() {
        return new DefaultDirectoryConfiguration(false);
    }

    private void writePresets(XmlWriter writer) throws IOException {
        writer.startElement(PRESETS_TAG);
        Hashtable<String, Hashtable<String, String>> hashtable = this.getPresets();
        Set<Map.Entry<String, Hashtable<String, String>>> set = hashtable.entrySet();
        for (Map.Entry<String, Hashtable<String, String>> entry : set) {
            writer.startElement(PRESET_TAG);
            String presetName = entry.getKey();
            writer.printAttribute(NAME, presetName);
            Hashtable<String, String> properties = entry.getValue();
            Enumeration<String> propertiesNames = properties.keys();
            while (propertiesNames.hasMoreElements()) {
                writer.startElement(PROPERTY_TAG);
                String propertyName = propertiesNames.nextElement();
                writer.printAttribute(NAME, propertyName);
                writer.printAttribute(VALUE, properties.get(propertyName));
                writer.endElement();
            }
            writer.endElement();
        }
        writer.endElement();
    }
}

