/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirectoryConfiguration;
import java.util.Hashtable;
import oracle.bpm.configuration.BaseConfiguration;
import oracle.bpm.configuration.ConfigurationSet;
import oracle.bpm.configuration.util.ValidationUtilities;

public abstract class AbstractDirectoryConfiguration<T extends BaseConfiguration>
implements DirectoryConfiguration<T> {
    private String admin;
    private ConfigurationSet<T> connectorsConfigurations;
    private String description;
    private String id;
    private Hashtable<String, Hashtable<String, String>> presets;
    private String scrambledAdminPassword;

    protected AbstractDirectoryConfiguration(String id) {
        this.id = id;
        this.presets = new Hashtable();
        this.connectorsConfigurations = ConfigurationSet.create();
    }

    @Override
    public String getPresetValue(String preset, String key) {
        String result = null;
        Hashtable<String, String> presetValues = this.presets.get(preset);
        if (presetValues != null) {
            result = presetValues.get(key);
        }
        return result;
    }

    @Override
    public void setPresetValue(String preset, String key, String value) {
        Hashtable<String, String> presetValues = this.presets.get(preset);
        if (presetValues == null) {
            presetValues = new Hashtable();
            this.presets.put(preset, presetValues);
        }
        presetValues.put(key, value);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getAdmin() {
        return this.admin;
    }

    @Override
    public void setAdmin(String admin) {
        this.admin = admin;
    }

    @Override
    public String getAdminPassword() {
        return ValidationUtilities.unscrambleText(this.scrambledAdminPassword);
    }

    @Override
    public String getAdminScrambledPassword() {
        return this.scrambledAdminPassword;
    }

    @Override
    public void setAdminPassword(String adminPassword) {
        this.scrambledAdminPassword = ValidationUtilities.scrambleText(adminPassword);
    }

    @Override
    public T getConfiguration(String configurationName) {
        return this.connectorsConfigurations.getEntry(configurationName);
    }

    @Override
    public ConfigurationSet<T> getConnectorsConfigurations() {
        return this.connectorsConfigurations;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Hashtable<String, Hashtable<String, String>> getPresets() {
        return this.presets;
    }

    protected void setConnectorsConfigurations(ConfigurationSet<T> connectorsConfigurations) {
        this.connectorsConfigurations = connectorsConfigurations;
    }
}

