/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.client.internal.processmodel.marshalling;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.io.fs.FileProjectLoader;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.bpm.services.common.logger.LoggerComponent;
import oracle.bpm.services.common.logger.Severity;
import oracle.bpm.services.internal.processmodel.model.IProcessModelPackage;
import oracle.bpm.services.internal.processmodel.model.impl.ProcessMarshallingException;
import oracle.bpm.services.internal.processmodel.model.impl.ProcessModelPackageImpl;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProcessModelLoader {
    private static final String CLASSNAME = "oracle.bpm.client.internal.processmodel.marshalling.ProcessModelLoader";

    private ProcessModelLoader() {
    }

    public static ProcessModelLoader create() {
        return new ProcessModelLoader();
    }

    public IProcessModelPackage unmarshall(@NotNull String bpmnXml) throws ProcessMarshallingException {
        try {
            return this.parse(bpmnXml);
        }
        catch (XMLStreamException e) {
            throw new ProcessMarshallingException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ProcessMarshallingException(e);
        }
        catch (IOException e) {
            throw new ProcessMarshallingException(e);
        }
        catch (SAXException e) {
            throw new ProcessMarshallingException(e);
        }
        catch (ProjectException e) {
            throw new ProcessMarshallingException((Exception)((Object)e));
        }
    }

    private IProcessModelPackage parse(String bpmnXml) throws XMLStreamException, ParserConfigurationException, IOException, SAXException, ProjectException, ProcessMarshallingException {
        FuegoProject project = null;
        String projectName = null;
        Process projectModel = null;
        Process processModel = null;
        LinkedList<Process> callees = new LinkedList<Process>();
        Locale defaultLanguage = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setCoalescing(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(bpmnXml)));
        NodeList list = document.getElementsByTagNameNS(ProcessModelPackageImpl.QNAME_MODELPACKAGE.getNamespaceURI(), ProcessModelPackageImpl.QNAME_MODELPACKAGE.getLocalPart());
        if (list.getLength() != 1) {
            String msg = "Root element not found in XML! Metadata XML seems to be invalid!";
            BPMLogger.log(LoggerComponent.COMPONENT_PROCESS_MODEL_SERVICE, Severity.DEBUG, CLASSNAME, "parse", msg + "\nXML:\n" + bpmnXml);
            throw new ProcessMarshallingException(msg);
        }
        Node rootNode = list.item(0);
        NodeList childNodes = rootNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (this.equalsNodeName(node, ProcessModelPackageImpl.QNAME_PROJECTMODEL)) {
                Node nameNode = node.getAttributes().getNamedItem(ProcessModelPackageImpl.ATTR_QNAME_PROJECTMODEL_NAME.getLocalPart());
                projectName = nameNode.getTextContent();
                project = this.createDummyProject(projectName);
                projectModel = (Process)project.createFromXml(Process.class, node.getTextContent());
                Node defaultLangNode = node.getAttributes().getNamedItem(ProcessModelPackageImpl.ATTR_QNAME_PROJECTMODEL_DEFAULTLOCALE.getLocalPart());
                String defaultLangStr = defaultLangNode.getTextContent();
                defaultLanguage = new Locale(defaultLangStr);
                project.getPreferences().setDefaultLanguage(defaultLanguage);
                continue;
            }
            if (this.equalsNodeName(node, ProcessModelPackageImpl.QNAME_PROCESSMODEL)) {
                if (project == null) {
                    throw this.logAndBuildMarshallingError(bpmnXml);
                }
                processModel = (Process)project.createFromXml(Process.class, node.getTextContent());
                continue;
            }
            if (!this.equalsNodeName(node, ProcessModelPackageImpl.QNAME_CALLEES)) continue;
            if (project == null) {
                throw this.logAndBuildMarshallingError(bpmnXml);
            }
            NodeList calleeNodes = node.getChildNodes();
            for (int j = 0; j < calleeNodes.getLength(); ++j) {
                Node calleeNode = calleeNodes.item(j);
                Process callee = (Process)project.createFromXml(Process.class, calleeNode.getTextContent());
                callees.add(callee);
            }
        }
        if (projectName == null || projectModel == null || processModel == null) {
            throw this.logAndBuildMarshallingError(bpmnXml);
        }
        return ProcessModelPackageImpl.create(projectModel, projectName, defaultLanguage, processModel, callees);
    }

    private ProcessMarshallingException logAndBuildMarshallingError(String bpmnXml) throws ProcessMarshallingException {
        String msg = "Process unmarshalling failed - missing elements! Process model XML seems to be invalid!";
        BPMLogger.log(LoggerComponent.COMPONENT_PROCESS_MODEL_SERVICE, Severity.DEBUG, CLASSNAME, "parse", msg + "\nXML:\n" + bpmnXml);
        return new ProcessMarshallingException(msg);
    }

    private FuegoProject createDummyProject(String projectName) {
        FuegoProject project = FuegoProject.createInMemory((String)projectName);
        project.setComponentCatalog((ComponentCatalog)TypeUtils.getDefaultCatalog());
        project.setLoader((ProjectLoader)new FileProjectLoader(null, (Project)project, null));
        return project;
    }

    private boolean equalsNodeName(Node node, QName expectedQName) {
        return node.getNamespaceURI().equals(expectedQName.getNamespaceURI()) && node.getLocalName().equals(expectedQName.getLocalPart());
    }

    static {
        FileProjectRepository repository = FileProjectRepository.create((File)new File("dummy_file"));
        RepositoryService.getInstance().setActiveRepository((ProjectRepository)repository);
    }
}

