/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.view.project.view.renderer;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.ProjectObjectRendererMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.ui.Image;

public interface ProjectObjectRenderer<PO extends ProjectObject> {
    public String getLabel(PO var1);

    public String getLocationLabel(PO var1);

    public Image getIcon(PO var1);

    public boolean supports(PO var1);

    public static class Default {
        private static Map<Class, Collection<ProjectObjectRenderer>> renderers;

        public static ProjectObjectRenderer get(ProjectObject po) {
            return Default.get(po, po.getRawClass());
        }

        public static String getLabel(ProjectObject projectObject) {
            return Default.get(projectObject).getLabel(projectObject);
        }

        public static Image getIcon(ProjectObject projectObject) {
            ProjectObjectRenderer renderer = Default.get(projectObject);
            if (renderer == null) {
                throw new IllegalStateException("Renderer not found for " + projectObject + " with raw class: " + projectObject.getRawClass());
            }
            return renderer.getIcon(projectObject);
        }

        private static ProjectObjectRenderer get(ProjectObject po, Class cl) {
            if (renderers == null) {
                renderers = Default.loadRenderers();
            }
            ProjectObjectRenderer result = null;
            Collection<ProjectObjectRenderer> objectRenderers = renderers.get(cl);
            if (objectRenderers != null) {
                for (ProjectObjectRenderer renderer : objectRenderers) {
                    if (!renderer.supports(po)) continue;
                    result = renderer;
                    break;
                }
            }
            if (result == null) {
                Class<?>[] ifaces = cl.getInterfaces();
                if (ifaces != null) {
                    Class<?> iface;
                    Class<?>[] arr$ = ifaces;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (result = Default.get(po, iface = arr$[i$])) == null; ++i$) {
                    }
                }
                if (result == null && cl.getSuperclass() != null) {
                    result = Default.get(po, cl.getSuperclass());
                }
            }
            return result;
        }

        private static Map<Class, Collection<ProjectObjectRenderer>> loadRenderers() {
            ExtensionService service = Platform.getExtensionService();
            HashMap<Class, Collection<ProjectObjectRenderer>> map = new HashMap<Class, Collection<ProjectObjectRenderer>>();
            List<Extension<ProjectObjectRendererMetadata>> all = service.getExtensionsByPoint(ProjectObjectRendererMetadata.class);
            for (Extension<ProjectObjectRendererMetadata> extension : all) {
                try {
                    Class<? extends ProjectObject> target = extension.getMetadata().objectClass();
                    ProjectObjectRenderer renderer = extension.instantiateAs(ProjectObjectRenderer.class);
                    if (map.containsKey(target)) {
                        ((Collection)map.get(target)).add(renderer);
                        continue;
                    }
                    HashSet<ProjectObjectRenderer> renderers = new HashSet<ProjectObjectRenderer>();
                    renderers.add(renderer);
                    map.put(target, renderers);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
            return map;
        }
    }
}

