/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.view.project.view.renderer;

import oracle.bpm.extensionpoint.metadata.ProjectObjectRendererMetadata;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.ui.Image;

@ProjectObjectRendererMetadata(objectClass=ProjectObject.class)
public class DefaultProjectObjectRenderer<PO extends ProjectObject>
implements ProjectObjectRenderer<PO> {
    private Class<? extends ProjectObject> objectClass;

    public DefaultProjectObjectRenderer() {
        ProjectObjectRendererMetadata metadata = this.getClass().getAnnotation(ProjectObjectRendererMetadata.class);
        this.objectClass = metadata.objectClass();
    }

    @Override
    public String getLabel(PO po) {
        String result;
        if (po instanceof Localizable) {
            Localizable localizable = (Localizable)po;
            result = localizable.getDefaultLabel();
        } else {
            result = po.getName();
        }
        return result;
    }

    @Override
    public String getLocationLabel(PO po) {
        return this.getLabel(po);
    }

    @Override
    public Image getIcon(PO po) {
        return null;
    }

    @Override
    public boolean supports(PO po) {
        return this.objectClass.isAssignableFrom(po.getClass());
    }
}

