/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.view.filter;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.UnknownProjectObject;
import oracle.bpm.project.model.activityguide.Milestone;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DefaultCatalogObject;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.catalog.ExternalRef;
import oracle.bpm.project.model.catalog.FaultObject;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.project.model.catalog.ReferenceObject;
import oracle.bpm.project.model.catalog.ServiceObject;
import oracle.bpm.project.model.catalog.SignalObject;
import oracle.bpm.project.model.catalog.SystemFaultObject;
import oracle.bpm.project.model.organization.OrganizationObject;
import oracle.bpm.project.model.processes.BpelProcess;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.view.filter.ConfigurableProjectFilter;
import oracle.bpm.project.view.filter.DefaultProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectFilters {
    public static final ProjectFilter DEFAULT = new DefaultProjectFilter();
    public static final ProjectFilter CATALOG = OnlyCatalogFilter.create(CatalogObject.class);
    public static final ProjectFilter HUMAN_TASKS = OnlyCatalogFilter.create(HumanTask.class);
    public static final ProjectFilter BPM_OBJECTS = OnlyCatalogFilter.create(BpmObject.class);
    public static final ProjectFilter BUSINESS_RULES = OnlyCatalogFilter.create(BusinessRule.class);
    public static final ProjectFilter SERVICE_OBJECTS = OnlyCatalogFilter.create(ServiceObject.class);
    public static final ProjectFilter FAULT_OBJECTS = OnlyCatalogFilter.create(FaultObject.class);
    public static final ProjectFilter ERROR_OBJECTS = OnlyCatalogFilter.create(ErrorObject.class);
    public static final ProjectFilter SIGNAL_OBJECT = OnlyCatalogFilter.create(SignalObject.class);
    public static final ProjectFilter REFERENCE_OBJECTS = OnlyCatalogFilter.create(ReferenceObject.class);
    public static final ProjectFilter INTERFACE_OBJECTS = OnlyCatalogFilter.create(InterfaceObject.class);
    public static final ProjectFilter NON_WSDL_OBJECTS = new AttributeCatalogFilter();
    public static final ProjectFilter DEFAULT_NAVIGATOR = new DefaultNavigator();
    public static final ProjectFilter BPM_OBJECTS_ONLY = new OnlyBusinessObjectFilter();
    public static final ProjectFilter BUSINESS_CATALOG = new BusinessCatalogFilter();
    public static final ProjectFilter BUSINESS_CATALOG_MODULES = new BusinessCatalogFilter(){
        {
            this.addExcluded(BpmObject.class);
            this.addExcluded(ServiceObject.class);
            this.addExcluded(new Predicate<ProjectObject>(){

                @Override
                public boolean check(@Nullable ProjectObject value) {
                    return value instanceof CatalogObject && ((CatalogObject)value).isSynthesized();
                }
            });
        }
    };
    public static final ProjectFilter BUSINESS_OBJECTS_AND_MODULES = new BusinessCatalogFilter(){
        {
            this.addExcluded(ServiceObject.class);
            this.addExcluded(CatalogMember.class);
            this.addExcluded(new Predicate<ProjectObject>(){

                @Override
                public boolean check(@Nullable ProjectObject value) {
                    return value instanceof CatalogObject && ((CatalogObject)value).isSynthesized();
                }
            });
        }
    };

    private static class OnlyCatalogFilter
    implements ProjectFilter {
        private final Class<? extends CatalogObject> cl;

        protected OnlyCatalogFilter(Class<? extends CatalogObject> cl) {
            this.cl = cl;
        }

        public static OnlyCatalogFilter create(Class<? extends CatalogObject> cl) {
            return new OnlyCatalogFilter(cl);
        }

        @Override
        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            Sequence result = object == object.getProject().getCatalogRoot() ? object.getDescendants(this.cl) : CollectionUtils.emptySequence();
            return result;
        }

        @Override
        public ProjectObjectContainer getParent(ProjectObject object) {
            CatalogModule root = object.getProject().getCatalogRoot();
            return object == root ? null : root;
        }
    }

    private static class OnlyBusinessObjectFilter
    extends OnlyCatalogFilter {
        protected OnlyBusinessObjectFilter() {
            super(BpmObject.class);
        }

        @Override
        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            ArrayList<CatalogObject> result = new ArrayList<CatalogObject>();
            Sequence<? extends ProjectObject> children = super.getChildren(object);
            for (ProjectObject projectObject : children) {
                CatalogObject t = (CatalogObject)projectObject;
                if (t.asBpmObject().isFaultObject()) continue;
                result.add(t);
            }
            return CollectionUtils.asSequence(result);
        }
    }

    private static class DefaultNavigator
    extends BusinessCatalogFilter {
        private DefaultNavigator() {
            this.addExcluded(OrganizationObject.class);
            this.addExcluded(DataObject.class);
            this.addExcluded(Lane.class);
            this.addExcluded(BpelProcess.class);
            this.addExcluded(Milestone.class);
            this.addExcluded(CatalogMember.class);
            this.addExcluded(new Predicate<ProjectObject>(){

                @Override
                public boolean check(ProjectObject value) {
                    return value instanceof Process && DefaultNavigator.isDefaultProcess((Process)value) || value instanceof FlowElement && !(value instanceof Process) || value.is(UnknownProjectObject.class);
                }
            });
        }

        @Override
        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            Sequence<? extends ProjectObject> result = super.getChildren(object);
            if (object == object.getProject().getModelsRoot()) {
                result = CollectionUtils.concat(result, object.getProject().getChildrenByType(BpelProcess.class));
            }
            return result;
        }

        @Override
        public ProjectObjectContainer getParent(ProjectObject object) {
            if (object instanceof BpelProcess) {
                return object.getProject().getModelsRoot();
            }
            return super.getParent(object);
        }

        private static boolean isDefaultProcess(Process process) {
            return "default".equals(process.getId()) && process.getParentObject() instanceof Project;
        }
    }

    private static class BusinessCatalogFilter
    extends ConfigurableProjectFilter {
        private BusinessCatalogFilter() {
            this.addExcluded(DefaultCatalogObject.class);
            this.addExcluded(ExternalRef.class);
            this.addExcluded(new Predicate<ProjectObject>(){

                @Override
                public boolean check(@Nullable ProjectObject value) {
                    return value instanceof CatalogType && ((CatalogType)value).isHidden();
                }
            });
        }
    }

    private static class AttributeCatalogFilter
    extends OnlyCatalogFilter {
        protected AttributeCatalogFilter() {
            super(BpmObject.class);
        }

        @Override
        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            ArrayList<CatalogObject> result = new ArrayList<CatalogObject>();
            Sequence<? extends ProjectObject> children = super.getChildren(object);
            for (ProjectObject projectObject : children) {
                CatalogObject t = (CatalogObject)projectObject;
                if (t.asBpmObject().isFromWsdl()) continue;
                result.add(t);
            }
            return CollectionUtils.asSequence(result);
        }
    }

    public static class HumanTaskFilter
    extends OnlyCatalogFilter {
        private final HumanTaskType humanTaskType;

        HumanTaskFilter(HumanTaskType humanTaskType) {
            super(HumanTask.class);
            this.humanTaskType = humanTaskType;
        }

        public static HumanTaskFilter create(HumanTaskType humanTaskType) {
            return new HumanTaskFilter(humanTaskType);
        }

        @Override
        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            Sequence<Object> result;
            Sequence<? extends ProjectObject> children = super.getChildren(object);
            if (this.humanTaskType != null) {
                ArrayList<ProjectObject> list = new ArrayList<ProjectObject>();
                for (ProjectObject projectObject : children) {
                    if (!(projectObject instanceof HumanTask) || ((HumanTask)projectObject).getHumanTaskType() != this.humanTaskType) continue;
                    list.add(projectObject);
                }
                result = CollectionUtils.asSequence(list);
            } else {
                result = children;
            }
            return result;
        }
    }

    public static class ErrorObjectFilter
    implements ProjectFilter {
        private final ProjectFilter errorObjectFilter;
        private boolean isShowSystemFault;

        private ErrorObjectFilter(boolean showSystemFault, boolean catchEvent) {
            this.isShowSystemFault = showSystemFault;
            this.errorObjectFilter = this.createFilter(catchEvent);
        }

        public static ErrorObjectFilter create(boolean catchEvent) {
            return new ErrorObjectFilter(false, catchEvent);
        }

        public void setShowSystemFault(boolean showSystemFault) {
            this.isShowSystemFault = showSystemFault;
        }

        @Override
        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            return this.getDelegateFilter().getChildren(object);
        }

        @Override
        public ProjectObjectContainer getParent(ProjectObject object) {
            return this.getDelegateFilter().getParent(object);
        }

        public boolean isShowSystemFault() {
            return this.isShowSystemFault;
        }

        private ProjectFilter createFilter(final boolean catchEvent) {
            ConfigurableProjectFilter result = new ConfigurableProjectFilter();
            result.addIncluded(new Predicate<ProjectObject>(){

                @Override
                public boolean check(@Nullable ProjectObject value) {
                    if (value instanceof ErrorObject) {
                        if (value instanceof SystemFaultObject) {
                            SystemFaultObject systemFaultObject = (SystemFaultObject)value;
                            return catchEvent && systemFaultObject.isCatcheable() || !catchEvent && systemFaultObject.isThrowable();
                        }
                        return true;
                    }
                    return false;
                }
            });
            return result;
        }

        private ProjectFilter getDelegateFilter() {
            return this.isShowSystemFault() ? this.errorObjectFilter : FAULT_OBJECTS;
        }
    }
}

