/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.view.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.view.filter.AbstractProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableProjectFilter
extends AbstractProjectFilter
implements ProjectFilter {
    private Map<ProjectObject, List<ProjectObject>> children = new HashMap<ProjectObject, List<ProjectObject>>();
    private Exception exception = new Exception();
    private List<Predicate<ProjectObject>> excluded = new ArrayList<Predicate<ProjectObject>>();
    private List<Predicate<ProjectObject>> included = new ArrayList<Predicate<ProjectObject>>();

    public ConfigurableProjectFilter() {
    }

    public ConfigurableProjectFilter(ProjectFilter delegate) {
        super(delegate);
    }

    public void addIncluded(final Class<? extends ProjectObject> type) {
        assert (type.isInterface()) : "Not an interface: " + type;
        this.addIncluded(new Predicate<ProjectObject>(){

            @Override
            public boolean check(@Nullable ProjectObject value) {
                return value != null && type.isAssignableFrom(value.getClass());
            }
        });
    }

    public void addIncluded(Predicate<ProjectObject> predicate) {
        this.included.add(predicate);
    }

    public void addExcluded(Predicate<ProjectObject> predicate) {
        this.excluded.add(predicate);
    }

    public void addExcluded(final Class<? extends ProjectObject> type) {
        this.addExcluded(new Predicate<ProjectObject>(){

            @Override
            public boolean check(@Nullable ProjectObject value) {
                return value != null && type.isAssignableFrom(value.getClass());
            }
        });
    }

    @Override
    @NotNull
    public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
        return CollectionUtils.asSequence(this.getOrCreateChildren((ProjectObject)object));
    }

    @Override
    public ProjectObjectContainer getParent(ProjectObject object) {
        return (ProjectObjectContainer)object.getParentObject();
    }

    protected boolean shouldEnter(ProjectObjectContainer objectContainer) {
        return true;
    }

    protected boolean isIncluded(ProjectObject po) {
        boolean allowed = false;
        for (Predicate<ProjectObject> includedType : this.included) {
            if (!includedType.check(po)) continue;
            allowed = true;
            break;
        }
        return allowed;
    }

    protected boolean isExcluded(ProjectObject po) {
        boolean mustExclude = false;
        for (Predicate<ProjectObject> excludedType : this.excluded) {
            if (!excludedType.check(po)) continue;
            mustExclude = true;
            break;
        }
        return mustExclude;
    }

    private List<ProjectObject> getOrCreateChildren(ProjectObject parent) {
        List<ProjectObject> result;
        List<ProjectObject> list = result = this.isCacheEnabled() ? this.children.get(parent) : null;
        if (result == null) {
            ProjectObjectContainer objectContainer;
            result = new ArrayList<ProjectObject>();
            if (parent instanceof ProjectObjectContainer && this.shouldEnter(objectContainer = (ProjectObjectContainer)parent)) {
                Sequence<? extends ProjectObject> children = this.getDelegate() != null ? this.getDelegate().getChildren(objectContainer) : objectContainer.getChildren();
                for (ProjectObject projectObject : children) {
                    boolean mustInclude;
                    assert (projectObject != parent) : parent;
                    if (this.isIncluded(projectObject)) {
                        result.add(projectObject);
                        continue;
                    }
                    if (this.isExcluded(projectObject) || projectObject == null || !(mustInclude = this.included.isEmpty() || !this.getOrCreateChildren(projectObject).isEmpty())) continue;
                    result.add(projectObject);
                }
            }
            if (this.isCacheEnabled()) {
                this.children.put(parent, result);
            }
        }
        return result;
    }

    private boolean isCacheEnabled() {
        return !this.included.isEmpty();
    }
}

