/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.serviceproperties;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertiesEnabled;
import oracle.bpm.project.model.processes.serviceproperties.ServiceProperty;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertySet;
import oracle.bpm.project.process.serviceproperties.ServicePropertyImpl;
import org.jetbrains.annotations.NotNull;

public class ServicePropertySetImpl
implements ServicePropertySet {
    ArrayList<ServiceProperty> properties = new ArrayList();
    private ServicePropertiesEnabled element;
    private boolean isInput;

    public ServicePropertySetImpl(@NotNull ServicePropertiesEnabled element, boolean isInput) {
        this.element = element;
        this.isInput = isInput;
    }

    @Override
    public ServiceProperty createServiceProperty(@NotNull String name, @NotNull Expression expression) {
        return new ServicePropertyImpl(this, name, expression);
    }

    @Override
    public void addServiceProperty(@NotNull ServiceProperty property) {
        this.properties.add(property);
    }

    @Override
    public void removeServiceProperty(@NotNull ServiceProperty property) {
        this.properties.remove(property);
    }

    @Override
    @NotNull
    public Sequence<ServiceProperty> getServiceProperties() {
        return CollectionUtils.asSequence(this.properties);
    }

    @Override
    public void clearServiceProperties() {
        this.properties.clear();
    }

    @Override
    public DataDeclarationContainer getContext() {
        return this.element.getParentObject();
    }

    @Override
    public boolean isInputServicePropertySet() {
        return this.isInput;
    }
}

