/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.policies;

import java.util.List;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class SequenceFlowPolicies {
    public static void checkSequenceFlow(FlowNode from, FlowNode target, boolean conditional, boolean isNew) throws ProjectException {
        List<SequenceFlow> transIt;
        if (from == target || !ModelUtils.shouldHaveIncomingSequenceFlow(target) || !ModelUtils.shouldHaveOutgoingSequenceFlow(from)) {
            throw new ProjectException(from, ProjectModelMsg.LOOP_ARROWS_NOT_AVAILABLE(target.getDefaultLabel()));
        }
        if (ModelUtils.isInterGroupTransition(from, target)) {
            Msg msg = target.getSubprocess() != null ? ProjectCompileMsg.MTM_02112((String)from.getDefaultLabel(), (String)target.getSubprocess().getDefaultLabel(), (String)target.getDefaultLabel()) : ProjectCompileMsg.MTM_02113((String)from.getDefaultLabel(), (String)from.getSubprocess().getDefaultLabel(), (String)target.getDefaultLabel());
            throw new ProjectException(from, msg);
        }
        if (from.isEvent()) {
            BoundaryEvent boundary;
            Event event = from.asAnyNode(Event.class);
            if (event.isEnd()) {
                throw new ProjectException(from);
            }
            if (conditional && !event.isStart()) {
                throw new ProjectException(from);
            }
            if (ModelUtils.isBoundaryEvent(event) && target.equals((boundary = event.asAnyNode(BoundaryEvent.class)).getBoundaryActivity())) {
                throw new ProjectException(from);
            }
            if (isNew && !from.getOutgoingSequenceFlows().isEmpty()) {
                throw new ProjectException(from);
            }
        }
        if (!(transIt = ModelUtils.getSequenceFlowsBetween(from, target)).isEmpty()) {
            throw new ProjectException(transIt.get(0), ProjectMsg.ALREADY_HAS_A_COND_UNCOND_TRANS(from.getDefaultLabel(), target.getDefaultLabel()));
        }
    }

    public static void checkSequenceFlow(FlowNode from, FlowNode target, boolean conditional) throws ProjectException {
        SequenceFlowPolicies.checkSequenceFlow(from, target, conditional, true);
    }

    public static boolean isValidNewSequenceFlowSource(@NotNull FlowNode source) {
        boolean result = ModelUtils.shouldHaveOutgoingSequenceFlow(source);
        if (result) {
            boolean empty = source.getOutgoingSequenceFlows().isEmpty();
            result = empty || ModelUtils.canHaveMoreThanOneOutgoingFlow(source);
        }
        return result;
    }

    public static boolean isValidNewSequenceFlowSourceAndTarget(@NotNull FlowNode source, @NotNull FlowNode target, boolean conditional) {
        boolean result = true;
        try {
            SequenceFlowPolicies.checkSequenceFlow(source, target, conditional);
        }
        catch (ProjectException e) {
            result = false;
        }
        return result;
    }
}

