/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.dataassociations;

import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.DataAssociationEnabled;
import oracle.bpm.project.model.processes.InputDataAssociationEnabled;
import oracle.bpm.project.model.processes.OutputDataAssociationEnabled;
import oracle.bpm.project.model.processes.dataassociations.DataAssignment;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataAssociationPropertiesManager {
    private DataAssociationEnabled dataAssociationEnabled;
    private ExpressionContext propertiesContext;

    public DataAssociationPropertiesManager(@NotNull DataAssociationEnabled dataAssociationEnabled) {
        this.dataAssociationEnabled = dataAssociationEnabled;
    }

    public static DataAssociationPropertiesManager createInput(@NotNull InputDataAssociationEnabled inputDataAssociationEnabled) {
        return new InputDataAssociationPropertiesManager(inputDataAssociationEnabled);
    }

    public static DataAssociationPropertiesManager createOutput(@NotNull OutputDataAssociationEnabled outputDataAssociationEnabled) {
        return new OutputDataAssociationPropertiesManager(outputDataAssociationEnabled);
    }

    public Expression createProperty(@NotNull String simplePath) {
        return ExpressionHelper.createSimpleExpression((String)simplePath, (ExpressionContext)this.getPropertiesContext());
    }

    public Expression getExpression(@NotNull Expression property) {
        Expression result = null;
        DataAssignment dataAssignment = this.findDataAssociation(property);
        if (dataAssignment != null) {
            DataAssignmentItem expressionItem = this.isInput() ? dataAssignment.getSource() : dataAssignment.getTarget();
            result = expressionItem.getExpression();
        }
        return result;
    }

    public void setExpression(@NotNull Expression property, @Nullable Expression expression) {
        DataAssignment dataAssignment = this.findDataAssociation(property);
        if (dataAssignment != null) {
            this.getDataAssociationSet().removeDataAssociation(dataAssignment);
        }
        if (expression != null) {
            Expression source = this.isInput() ? expression : property;
            Expression target = this.isInput() ? property : expression;
            DataAssignment newDataAssignment = this.getDataAssociationSet().createDataAssignment(source, target);
            this.getDataAssociationSet().addDataAssociation(newDataAssignment);
        }
    }

    protected abstract DataAssociationSet getDataAssociationSet();

    protected abstract boolean isInput();

    protected DataAssociationEnabled getDataAssociationEnabled() {
        return this.dataAssociationEnabled;
    }

    private ExpressionContext getPropertiesContext() {
        if (this.propertiesContext == null) {
            DataAssignmentItemEndpoint propertiesEndpoint = this.isInput() ? DataAssignmentItemEndpoint.TARGET : DataAssignmentItemEndpoint.SOURCE;
            DataDeclarationContainer container = this.getDataAssociationSet().getDataDeclarationContainer(propertiesEndpoint);
            this.propertiesContext = new ExpressionContext(container, true);
        }
        return this.propertiesContext;
    }

    private DataAssignment findDataAssociation(@NotNull Expression argumentPath) {
        DataAssignment result = null;
        for (DataAssignment dataAssignment : this.getDataAssociationSet().getDataAssignments()) {
            DataAssignmentItem propertyItem = this.isInput() ? dataAssignment.getTarget() : dataAssignment.getSource();
            if (!argumentPath.equals(propertyItem.getExpression())) continue;
            result = dataAssignment;
            break;
        }
        return result;
    }

    private static class OutputDataAssociationPropertiesManager
    extends DataAssociationPropertiesManager {
        public OutputDataAssociationPropertiesManager(@NotNull OutputDataAssociationEnabled outputDataAssociationEnabled) {
            super(outputDataAssociationEnabled);
        }

        @Override
        protected DataAssociationSet getDataAssociationSet() {
            return this.getDataAssociationEnabled().getOutputDataAssociationSet();
        }

        @Override
        protected boolean isInput() {
            return false;
        }

        @Override
        protected OutputDataAssociationEnabled getDataAssociationEnabled() {
            return (OutputDataAssociationEnabled)super.getDataAssociationEnabled();
        }
    }

    private static class InputDataAssociationPropertiesManager
    extends DataAssociationPropertiesManager {
        public InputDataAssociationPropertiesManager(@NotNull InputDataAssociationEnabled inputDataAssociationEnabled) {
            super(inputDataAssociationEnabled);
        }

        @Override
        protected DataAssociationSet getDataAssociationSet() {
            return this.getDataAssociationEnabled().getInputDataAssociationSet();
        }

        @Override
        protected boolean isInput() {
            return true;
        }

        @Override
        protected InputDataAssociationEnabled getDataAssociationEnabled() {
            return (InputDataAssociationEnabled)super.getDataAssociationEnabled();
        }
    }
}

