/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.dataassociations;

import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.model.processes.dataassociations.DataAssignment;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentOperation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.process.dataassociations.DataAssignmentItemImpl;
import oracle.bpm.project.process.dataassociations.DataAssociationImpl;
import org.jetbrains.annotations.NotNull;

class DataAssignmentImpl
extends DataAssociationImpl
implements DataAssignment {
    private DataAssignmentOperation operation = DataAssignmentOperation.getDefault();
    private DataAssignmentItem source;
    private DataAssignmentItem target;

    private DataAssignmentImpl(@NotNull DataAssociationSet parent, @NotNull Expression sourceExpression, @NotNull Expression targetExpression) {
        super(parent);
        this.source = DataAssignmentItemImpl.create(this, DataAssignmentItemEndpoint.SOURCE, sourceExpression);
        this.target = DataAssignmentItemImpl.create(this, DataAssignmentItemEndpoint.TARGET, targetExpression);
    }

    public static DataAssignment create(@NotNull DataAssociationSet parent, @NotNull Expression sourceExpression, @NotNull Expression targetExpression) {
        return new DataAssignmentImpl(parent, sourceExpression, targetExpression);
    }

    @Override
    @NotNull
    public DataAssignmentItem getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public DataAssignmentItem getTarget() {
        return this.target;
    }

    @Override
    public ExpressionMode getExpressionMode() {
        return this.getParentObject().isInput() ? this.source.getExpression().getMode() : this.target.getExpression().getMode();
    }

    public String toString() {
        return this.source.toString() + " -> " + this.target.toString();
    }

    @Override
    public boolean isDataAssignment() {
        return true;
    }

    @Override
    public DataAssignmentOperation getOperation() {
        return this.operation;
    }

    @Override
    public void setOperation(@NotNull DataAssignmentOperation operation) {
        this.operation = operation;
    }
}

