/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.conversational;

import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.project.compile.process.ConversationalHelper;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.project.model.catalog.ServiceObject;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ServiceCallConversationDefinition;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.ServiceCallConversationalDefinition;
import oracle.bpm.project.process.conversational.ConversationalDefinitionImpl;
import org.jetbrains.annotations.NotNull;

public class ServiceCallConversationalDefinitionImpl
extends ConversationalDefinitionImpl
implements ServiceCallConversationalDefinition {
    private String operationId;

    public ServiceCallConversationalDefinitionImpl(@NotNull Conversational conversational) {
        super(conversational);
    }

    @Override
    public ServiceObject getService() {
        ServiceObject result = null;
        ServiceCallConversationDefinition conversationDefinition = this.getServiceCallConversationDefinition();
        if (conversationDefinition != null) {
            InterfaceObject callbackInterface;
            Conversational conversational = this.getParentObject();
            ServiceObject service = conversationDefinition.getService();
            if (conversational.getConversationalType().isSender()) {
                result = service;
            } else if (service != null && (callbackInterface = ConversationalHelper.getCallbackInterface((InterfaceObject)service)) instanceof ServiceObject) {
                result = (ServiceObject)callbackInterface;
            }
        }
        return result;
    }

    @Override
    public CatalogMember getOperation() {
        ServiceObject service;
        CatalogMember result = null;
        if (!Str.isEmpty(this.operationId) && (service = this.getService()) != null) {
            result = service.findMember(this.operationId);
        }
        return result;
    }

    @Override
    public void setOperation(CatalogMember operation) {
        String operationId = operation != null ? operation.getName() : null;
        this.setOperationId(operationId);
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        if (Any.equals(this.operationId, operationId)) {
            return;
        }
        this.operationId = operationId;
        this.events().objectChanged();
    }

    private ServiceCallConversationDefinition getServiceCallConversationDefinition() {
        ServiceCallConversationDefinition result = null;
        Conversation conversation = this.getParentObject().getConversation();
        if (conversation != null) {
            result = conversation.getConversationDefinition().as(ServiceCallConversationDefinition.class);
        }
        return result;
    }
}

