/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.conversational;

import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.features.InputArgumentsFeature;
import oracle.bpm.project.model.features.OutputArgumentsFeature;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.conversational.DefineInterfaceConversationalDefinition;
import oracle.bpm.project.process.conversational.ConversationalDefinitionImpl;
import oracle.bpm.type.AmbiguousTypeNameException;
import org.jetbrains.annotations.NotNull;

public class DefineInterfaceConversationalDefinitionImpl
extends ConversationalDefinitionImpl
implements DefineInterfaceConversationalDefinition {
    private String definedOperationName;
    private String errorId;
    private String replyToId;

    public DefineInterfaceConversationalDefinitionImpl(@NotNull Conversational conversational) {
        super(conversational);
    }

    @Override
    public DataDeclarationContainer getArgumentsContainer() {
        DataDeclarationContainer result = null;
        Conversational conversational = this.getParentObject();
        InputArgumentsFeature inputArgumentsFeature = conversational.getFeature(InputArgumentsFeature.class);
        if (inputArgumentsFeature != null) {
            result = inputArgumentsFeature.getCustomArgumentsContainer();
        } else {
            OutputArgumentsFeature outputArgumentsFeature = conversational.getFeature(OutputArgumentsFeature.class);
            if (outputArgumentsFeature != null) {
                result = outputArgumentsFeature.getCustomArgumentsContainer();
            }
        }
        return result;
    }

    @Override
    public String getDefinedOperationName() {
        return this.definedOperationName;
    }

    @Override
    public void setDefinedOperationName(String definedOperationName) {
        if (Any.equals(this.definedOperationName, definedOperationName)) {
            return;
        }
        this.definedOperationName = definedOperationName;
        if (definedOperationName != null) {
            this.replyToId = null;
            this.errorId = null;
        }
        this.events().objectChanged();
    }

    @Override
    public Conversational getReplyTo() {
        Process process;
        Conversational result = null;
        if (!Str.isEmpty(this.replyToId) && (process = this.getParentObject().getProcess()) != null) {
            result = process.findDescendant(Conversational.class, this.replyToId);
        }
        return result;
    }

    @Override
    public void setReplyTo(Conversational replyTo) {
        String replyToId = replyTo != null ? replyTo.getId() : null;
        this.setReplyToId(replyToId);
    }

    public void setReplyToId(String replyToId) {
        if (Any.equals(this.replyToId, replyToId)) {
            return;
        }
        this.replyToId = replyToId;
        if (replyToId != null) {
            this.definedOperationName = null;
        }
        this.events().objectChanged();
    }

    public String getReplyToId() {
        return this.replyToId;
    }

    @Override
    public ErrorObject getError() {
        Project project;
        ErrorObject result = null;
        if (!Str.isEmpty(this.errorId) && (project = this.getProject()) != null) {
            try {
                result = (ErrorObject)project.findCatalogObject(this.errorId);
            }
            catch (AmbiguousTypeNameException ambiguousTypeNameException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void setError(ErrorObject error) {
        String errorId = error != null ? error.getId() : null;
        this.setErrorId(errorId);
    }

    public void setErrorId(String errorId) {
        if (Any.equals(this.errorId, errorId)) {
            return;
        }
        this.errorId = errorId;
        if (errorId != null) {
            this.definedOperationName = null;
        }
        this.events().objectChanged();
    }

    public String getErrorId() {
        return this.errorId;
    }
}

