/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.conversation;

import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.ReferenceObject;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationDefinition;
import oracle.bpm.project.model.processes.conversation.UseInterfaceConversationDefinition;
import oracle.bpm.project.process.conversation.ConversationDefinitionImpl;
import oracle.bpm.type.AmbiguousTypeNameException;
import org.jetbrains.annotations.NotNull;

public class UseInterfaceConversationDefinitionImpl
extends ConversationDefinitionImpl
implements UseInterfaceConversationDefinition {
    private String referenceId;

    public UseInterfaceConversationDefinitionImpl(@NotNull Conversation conversation) {
        super(conversation);
    }

    @Override
    public ReferenceObject getReference() {
        Project project;
        ReferenceObject result = null;
        if (!Str.isEmpty(this.referenceId) && (project = this.getProject()) != null) {
            try {
                CatalogObject catalogObject = project.findCatalogObject(this.referenceId);
                if (catalogObject instanceof ReferenceObject) {
                    result = (ReferenceObject)catalogObject;
                }
            }
            catch (AmbiguousTypeNameException ambiguousTypeNameException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void setReference(ReferenceObject reference) {
        String referenceId = reference != null ? reference.getId() : null;
        this.setReferenceId(referenceId);
    }

    public void setReferenceId(String referenceId) {
        if (Any.equals(this.referenceId, referenceId)) {
            return;
        }
        this.referenceId = referenceId;
        this.events().objectChanged();
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    @Override
    public ConversationDefinition copy() {
        UseInterfaceConversationDefinitionImpl result = new UseInterfaceConversationDefinitionImpl(this.getParentObject());
        result.setReference(this.getReference());
        return result;
    }

    @Override
    public void applyFrom(@NotNull ConversationDefinition source) {
        if (source instanceof UseInterfaceConversationDefinition) {
            UseInterfaceConversationDefinition sourceDefinition = source.as(UseInterfaceConversationDefinition.class);
            this.setReference(sourceDefinition.getReference());
        }
    }
}

