/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process.conversation;

import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.ServiceObject;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationDefinition;
import oracle.bpm.project.model.processes.conversation.ServiceCallConversationDefinition;
import oracle.bpm.project.process.conversation.ConversationDefinitionImpl;
import oracle.bpm.type.AmbiguousTypeNameException;
import org.jetbrains.annotations.NotNull;

public class ServiceCallConversationDefinitionImpl
extends ConversationDefinitionImpl
implements ServiceCallConversationDefinition {
    private String serviceId;

    public ServiceCallConversationDefinitionImpl(@NotNull Conversation conversation) {
        super(conversation);
    }

    @Override
    public ServiceObject getService() {
        Project project;
        ServiceObject result = null;
        if (!Str.isEmpty(this.serviceId) && (project = this.getProject()) != null) {
            try {
                CatalogObject catalogObject = project.findCatalogObject(this.serviceId);
                if (catalogObject instanceof ServiceObject) {
                    result = (ServiceObject)catalogObject;
                }
            }
            catch (AmbiguousTypeNameException ambiguousTypeNameException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void setService(ServiceObject service) {
        String serviceId = service != null ? service.getId() : null;
        this.setServiceId(serviceId);
    }

    public void setServiceId(String serviceId) {
        if (Any.equals(this.serviceId, serviceId)) {
            return;
        }
        this.serviceId = serviceId;
        this.events().objectChanged();
    }

    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public ConversationDefinition copy() {
        ServiceCallConversationDefinitionImpl result = new ServiceCallConversationDefinitionImpl(this.getParentObject());
        result.setService(this.getService());
        return result;
    }

    @Override
    public void applyFrom(@NotNull ConversationDefinition source) {
        if (source instanceof ServiceCallConversationDefinition) {
            ServiceCallConversationDefinition sourceDefinition = source.as(ServiceCallConversationDefinition.class);
            this.setService(sourceDefinition.getService());
        }
    }
}

