/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.process;

import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.LoopCharacteristicsImpl;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.ArgumentsEnabled;
import oracle.bpm.project.model.processes.InputArgumentsEnabled;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.MultiInstanceBehaviour;
import oracle.bpm.project.model.processes.MultiInstanceFeature;
import oracle.bpm.project.model.processes.OutputArgumentsEnabled;
import oracle.bpm.project.model.processes.activities.LoopCharacteristicsFeature;
import org.jetbrains.annotations.NotNull;

public class MultiInstanceImpl
extends LoopCharacteristicsImpl
implements MultiInstance {
    public MultiInstanceImpl(@NotNull Activity activity) {
        super(activity);
    }

    @Override
    public boolean isSequential() {
        return this.getMultiInstanceFeature().getIsSequential().getValue();
    }

    @Override
    public void setSequential(boolean isSequential) {
        this.getMultiInstanceFeature().getIsSequential().setValue(isSequential);
    }

    @Override
    public Expression getLoopCardinality() {
        return this.getMultiInstanceFeature().getCardinalityExpression().getValue();
    }

    @Override
    public void setLoopCardinality(Expression loopCardinality) {
        if (Any.equals(this.getLoopCardinality(), loopCardinality)) {
            return;
        }
        this.getMultiInstanceFeature().getCardinalityExpression().setValue(loopCardinality);
        if (loopCardinality != null) {
            this.setLoopDataInput(null);
            this.setLoopDataOutput(null);
        }
    }

    @Override
    public boolean hasCompletionCondition() {
        return this.getCompletionCondition() != null;
    }

    @Override
    public Expression getCompletionCondition() {
        return this.getMultiInstanceFeature().getCompleteCondition().getValue();
    }

    @Override
    public void setCompletionCondition(Expression completionCondition) {
        this.getMultiInstanceFeature().getCompleteCondition().setValue(completionCondition);
    }

    @Override
    public DataDeclaration getLoopDataInput() {
        ArgumentsEnabled argumentsEnabled;
        DataDeclaration result = null;
        Activity parent = this.getParent();
        if (ArgumentsEnabled.class.isAssignableFrom(parent.getRawClass()) && (argumentsEnabled = (ArgumentsEnabled)((Object)parent)).isInputArgumentsEnabled()) {
            InputArgumentsEnabled inputArgumentsEnabled = (InputArgumentsEnabled)argumentsEnabled;
            DataDeclarationContainer inputArgumentsContainer = inputArgumentsEnabled.getInputArgumentsContainer();
            String loopDataInputName = this.getMultiInstanceFeature().getLoopDataInputName();
            if (!Str.isEmpty(loopDataInputName)) {
                result = inputArgumentsContainer.findDeclaration(loopDataInputName);
            }
        }
        return result;
    }

    @Override
    public void setLoopDataInput(DataDeclaration dataInput) {
        String dataInputName;
        String string = dataInputName = dataInput != null ? dataInput.getName() : null;
        if (Any.equals(this.getMultiInstanceFeature().getLoopDataInputName(), dataInputName)) {
            return;
        }
        this.getMultiInstanceFeature().setLoopDataInputName(dataInputName);
        if (dataInput != null) {
            this.setLoopCardinality(null);
        }
    }

    @Override
    public DataDeclaration getLoopDataOutput() {
        ArgumentsEnabled argumentsEnabled;
        DataDeclaration result = null;
        Activity parent = this.getParent();
        if (ArgumentsEnabled.class.isAssignableFrom(parent.getRawClass()) && (argumentsEnabled = (ArgumentsEnabled)((Object)parent)).isOutputArgumentsEnabled()) {
            OutputArgumentsEnabled outputArgumentsEnabled = (OutputArgumentsEnabled)argumentsEnabled;
            DataDeclarationContainer outputArgumentsContainer = outputArgumentsEnabled.getOutputArgumentsContainer();
            String loopDataOutputName = this.getMultiInstanceFeature().getLoopDataOutputName();
            if (!Str.isEmpty(loopDataOutputName)) {
                result = outputArgumentsContainer.findDeclaration(loopDataOutputName);
            }
        }
        return result;
    }

    @Override
    public void setLoopDataOutput(DataDeclaration dataOutput) {
        String dataOutputName;
        String string = dataOutputName = dataOutput != null ? dataOutput.getName() : null;
        if (Any.equals(this.getMultiInstanceFeature().getLoopDataOutputName(), dataOutputName)) {
            return;
        }
        this.getMultiInstanceFeature().setLoopDataOutputName(dataOutputName);
        if (dataOutput != null) {
            this.setLoopCardinality(null);
        }
    }

    @Override
    public MultiInstanceBehaviour getMultiInstanceBehavior() {
        return MultiInstanceBehaviour.ALL;
    }

    private MultiInstanceFeature getMultiInstanceFeature() {
        MultiInstanceFeature result = null;
        LoopCharacteristicsFeature loopCharacteristicsFeature = this.getParent().getFeature(LoopCharacteristicsFeature.class);
        if (loopCharacteristicsFeature != null) {
            result = loopCharacteristicsFeature.getMultiInstanceFeature();
        }
        return result;
    }
}

