/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler.checker;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.organization.compiler.checker.OrganizationCheckerFactory;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;

public class OrganizationalUnitCalendarRuleChecker
implements ProjectObjectChecker<OrganizationalUnit> {
    private Collection<ProjectObjectChecker> participantOuCheckers = new ArrayList<ProjectObjectChecker>();

    public OrganizationalUnitCalendarRuleChecker(Organization organization) {
        this.participantOuCheckers.add(OrganizationCheckerFactory.getCalendarRuleExistenceChecker());
    }

    @Override
    public MsgList check(OrganizationalUnit ou) {
        MsgList messages = MsgList.create();
        CalendarRule crAssigned = this.getOuCalendarRuleAssigned(ou);
        if (crAssigned != null) {
            for (ProjectObjectChecker projectObjectChecker : this.participantOuCheckers) {
                messages.addAll(projectObjectChecker.check(crAssigned));
            }
        }
        return messages;
    }

    private CalendarRule getOuCalendarRuleAssigned(OrganizationalUnit ou) {
        String crAssignedId;
        if (ou.getCalendarRule() != null) {
            return ou.getCalendarRule();
        }
        CalendarRuleAssignment assignment = ou.getCalendarRuleAssignment();
        String string = crAssignedId = assignment != null ? assignment.getCalendarRuleId() : null;
        if (crAssignedId != null && !"".equalsIgnoreCase(crAssignedId)) {
            return ou.getOrganization().createCalendarRule(crAssignedId);
        }
        return null;
    }
}

