/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler.checker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.project.compiler.AbstractCompilerExtension;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.HolidayRule;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.organization.compiler.checker.OrganizationCheckerFactory;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;

@CompilerExtensionMetadata
public class OrganizationCompiler
extends AbstractCompilerExtension<Organization> {
    private Collection<ProjectObjectChecker> organizationCheckers = new ArrayList<ProjectObjectChecker>();

    public OrganizationCompiler() {
        super(Organization.class, Arrays.asList(ProjectObjectType.ORGANIZATION));
        this.organizationCheckers.add(OrganizationCheckerFactory.getDuplicateProjectObjectChildChecker(ProjectMsg.ROLE.toString(), Role.class));
        this.organizationCheckers.add(OrganizationCheckerFactory.getDuplicateProjectObjectChildChecker(ProjectMsg.CALENDAR_RULE.toString(), CalendarRule.class));
        this.organizationCheckers.add(OrganizationCheckerFactory.getDuplicateProjectObjectChildChecker(ProjectMsg.HOLIDAY_RULE.toString(), HolidayRule.class));
    }

    public MsgList check(Organization organization) {
        MsgList msgList = MsgList.create();
        for (ProjectObjectChecker checker : this.organizationCheckers) {
            msgList.addAll(checker.check(organization));
        }
        return msgList;
    }

    @Override
    public boolean supports(Organization organization) {
        return true;
    }

    @Override
    public void compile(Organization organization, CompilationSession session) throws ProjectException {
        super.reportErrors(this.check(organization), organization);
    }
}

