/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler.checker;

import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.organization.AssignableToGroup;
import oracle.bpm.project.model.organization.GroupAssignment;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;

public class GroupsAssignedChecker
implements ProjectObjectChecker<AssignableToGroup> {
    private Organization organization;

    public GroupsAssignedChecker(Organization organization) {
        this.organization = organization;
    }

    @Override
    public MsgList check(AssignableToGroup assignableToGroup) {
        MsgList messages = MsgList.create();
        for (GroupAssignment groupAssignment : assignableToGroup.getGroupAssignments()) {
            if (groupAssignment.getGroup() != null && (groupAssignment.getGroup() == null || this.organization.findGroup(groupAssignment.getGroup().getId()) != null)) continue;
            messages.add(ProjectMsg.NON_EXISTENT_GROUP);
        }
        return messages;
    }
}

