/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler.checker;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.organization.compiler.checker.OrganizationCheckerFactory;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;

public class GroupChecker
implements ProjectObjectChecker<Group> {
    private Collection<ProjectObjectChecker> groupCheckers = new ArrayList<ProjectObjectChecker>();

    public GroupChecker(Organization organization) {
        this.groupCheckers.add(OrganizationCheckerFactory.getRolesAssignedChecker(organization));
        this.groupCheckers.add(OrganizationCheckerFactory.getGroupsAssignedChecker(organization));
    }

    @Override
    public MsgList check(Group group) {
        MsgList messages = MsgList.create();
        for (ProjectObjectChecker projectObjectChecker : this.groupCheckers) {
            messages.addAll(projectObjectChecker.check(group));
        }
        return messages;
    }
}

