/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler.checker;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;
import org.jetbrains.annotations.Nullable;

public class DuplicateProjectObjectChildChecker<E extends ProjectObject>
implements ProjectObjectChecker<ProjectObjectContainer> {
    private Class<E> childType;
    private String projectObjectType;

    public DuplicateProjectObjectChildChecker(String projectObjectType, Class<E> childType) {
        this.projectObjectType = projectObjectType;
        this.childType = childType;
    }

    @Override
    public MsgList check(ProjectObjectContainer parent) {
        ArrayList duplicatedChildren = new ArrayList();
        MsgList msgList = MsgList.create();
        Sequence<E> childrenByType = parent.getChildrenByType(this.childType);
        for (final ProjectObject e : childrenByType) {
            Sequence<E> selectedList;
            if (duplicatedChildren.contains(e) || CollectionUtils.size(selectedList = childrenByType.select(new Predicate<E>(){

                @Override
                public boolean check(@Nullable E value) {
                    return e.getName().equals(value.getName());
                }
            })) <= 1) continue;
            selectedList.addAllTo(duplicatedChildren);
            msgList.add(ProjectMsg.DUPLICATE_PROJECT_OBJECT_NAME(this.projectObjectType, e.getName()));
        }
        return msgList;
    }
}

