/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization.compiler;

import java.util.Arrays;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.project.compiler.AbstractCompilerExtension;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.organization.compiler.checker.OrganizationCheckerFactory;
import oracle.bpm.project.organization.compiler.checker.ProjectObjectChecker;

@CompilerExtensionMetadata
public class ParticipantCompiler
extends AbstractCompilerExtension<Participant> {
    public ParticipantCompiler() {
        super(Participant.class, Arrays.asList(ProjectObjectType.PARTICIPANT));
    }

    @Override
    public void compile(Participant participant, CompilationSession session) throws ProjectException {
        ProjectObjectChecker<Participant> participantChecker = OrganizationCheckerFactory.getParticipantChecker(participant.getOrganization());
        super.reportErrors(participantChecker.check(participant), participant);
    }

    @Override
    public boolean supports(Participant participant) {
        return true;
    }
}

