/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.Collection;
import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.project.identity.MemberContainerImpl;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.organization.AssignableToRole;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.PotentialAssignee;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.organization.RoleAssignment;
import oracle.bpm.project.model.organization.RoleEscalation;
import org.jetbrains.annotations.NotNull;

class RoleProxy
extends MemberContainerImpl
implements Comparable<Role>,
Role,
ProjectObject.Mutable {
    private String id;
    private boolean notify = true;
    private String projectId;

    RoleProxy(Project project, String projectId, String id) {
        super(project);
        this.projectId = projectId;
        this.id = id;
    }

    @Override
    public void addCalendarRuleAssignment(CalendarRuleAssignment calendarRuleAssignment) {
        this.getRole().addCalendarRuleAssignment(calendarRuleAssignment);
    }

    @Override
    public void addRoleAssignment(RoleAssignment roleAssignment) {
        this.getRole().addRoleAssignment(roleAssignment);
    }

    @Override
    public CalendarRuleAssignment.Mutable createCalendarRuleAssignment() {
        return this.getRole().createCalendarRuleAssignment();
    }

    @Override
    public void setCalendarRuleAssignment(Collection<CalendarRuleAssignment> calendarRuleAssignments) {
        this.getRole().setCalendarRuleAssignment(calendarRuleAssignments);
    }

    @Override
    public void removeAllRoleAssignments() {
        this.getRole().removeAllRoleAssignments();
    }

    @Override
    public boolean isProcessOwner() {
        return this.getRole().isProcessOwner();
    }

    @Override
    public void removeCalendarRuleAssignments(CalendarRule calendarRule) {
        this.getRole().removeCalendarRuleAssignments(calendarRule);
    }

    @Override
    public void removeCalendarRuleAssignments(OrganizationalUnit ou) {
        this.getRole().removeCalendarRuleAssignments(ou);
    }

    @Override
    public PotentialAssignee getPotentialAssignee() {
        return this.getRole().getPotentialAssignee();
    }

    @Override
    public void setPotentialAssignee(PotentialAssignee potentialAssignee) {
        this.getRole().setPotentialAssignee(potentialAssignee);
    }

    @Override
    public void removeCalendarRuleAssignment(CalendarRuleAssignment calendarRuleAssignment) {
        this.getRole().removeCalendarRuleAssignment(calendarRuleAssignment);
    }

    @Override
    public void removeRoleAssignment(RoleAssignment roleAssignment) {
        this.getRole().removeRoleAssignment(roleAssignment);
    }

    @Override
    public void setDescription(String description) {
        this.getRole().setDescription(description);
    }

    @Override
    public AssignableToRole findAssignedObject(String assignedObjectId) {
        return this.getRole().findAssignedObject(assignedObjectId);
    }

    @Override
    public void setName(String name) {
        this.getRole().setName(name);
    }

    @Override
    public void setShared(boolean shared) {
        this.getRole().setShared(shared);
    }

    @Override
    public boolean isShared() {
        return this.getRole().isShared();
    }

    @Override
    public RoleEscalation getRoleEscalation() {
        return this.getRole().getRoleEscalation();
    }

    @Override
    public void setRoleEscalation(RoleEscalation roleEscalation) {
        this.getRole().setRoleEscalation(roleEscalation);
    }

    @Override
    public String getName() {
        return this.getRole().getName();
    }

    @Override
    public Collection<CalendarRuleAssignment> getCalendarRuleAssignment() {
        return this.getRole().getCalendarRuleAssignment();
    }

    @Override
    public String getDefaultLabel() {
        String result;
        try {
            Locale locale = this.getProject().getPreferences().getDefaultLanguage();
            result = this.getRole().getLabel(locale);
            if (result == null || result.trim().length() == 0) {
                result = this.getId();
            }
        }
        catch (RuntimeException e) {
            result = this.getId();
        }
        return result;
    }

    @Override
    public String getDescription() {
        return this.getRole().getDescription();
    }

    @Override
    public String getLabel(Locale locale) {
        return this.getRole().getLabel(locale);
    }

    @Override
    public LocaleStringMap getLabelMap() {
        return this.getRole().getLabelMap();
    }

    @Override
    public Collection<RoleAssignment> getRoleAssignments() {
        return this.getRole().getRoleAssignments();
    }

    @Override
    public boolean isReferencedByProcesses() {
        return this.getRole().isReferencedByProcesses();
    }

    @Override
    public boolean isVirtual() {
        return this.getRole().isVirtual();
    }

    @Override
    public Organization getOrganization() {
        return this.getRole().getOrganization();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getRole().getParentObject();
    }

    @Override
    public Path getPath() {
        return this.getRole().getPath();
    }

    @Override
    @NotNull
    public Project getProject() {
        return super.getProject();
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return this.getRole().getProjectObjectType();
    }

    @Override
    public boolean isActive() {
        return this.getRole().isActive();
    }

    @Override
    public boolean isDescendantOf(ProjectObject projectObject) {
        return this.getRole().isDescendantOf(projectObject);
    }

    @Override
    public boolean isReadOnly() {
        return this.getRole().isReadOnly();
    }

    @Override
    public void replace(ProjectObject newObject) throws ProjectException {
        this.getRole().replace(newObject);
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        this.getRole().visit(visitor);
    }

    @Override
    public void setId(String id) {
        this.getRole().setId(id);
    }

    @Override
    public void setReadOnly(boolean value) {
        this.getRole().setReadOnly(value);
    }

    public boolean isNotificationsEnabled() {
        return this.notify;
    }

    public void setNotificationsEnabled(boolean b) {
        this.notify = b;
    }

    @Override
    public int compareTo(Role o) {
        return this.getRole().getId().compareTo(o.getId());
    }

    public String getProjectId() {
        return this.projectId;
    }

    public final String toString() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RoleProxy) {
            RoleProxy otherRole = (RoleProxy)o;
            return otherRole.getProjectId().equals(otherRole.getProjectId()) && this.getId().equals(otherRole.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getProjectId().hashCode() << 4 ^ this.getId().hashCode();
    }

    @Override
    public boolean isDefault() {
        return this.getRole().isDefault();
    }

    @Override
    public void setDefault(boolean isDefault) {
        this.getRole().setDefault(isDefault);
    }

    @Override
    public void delete() throws ProjectException {
        this.getRole().delete();
    }

    @Override
    public Class getRawClass() {
        return Role.class;
    }

    @Override
    public boolean is(Class<? extends ProjectObject> clazz) {
        return clazz.isAssignableFrom(this.getRawClass());
    }

    private ProjectRepository getProjectRepository() {
        ProjectLoader loader = this.getProject().getLoader();
        return loader != null ? loader.getProjectRepository() : null;
    }

    private Role getRole() {
        Project project;
        Role result = null;
        ProjectRepository repository = this.getProjectRepository();
        if (repository != null && (project = repository.getProject(this.projectId)) != null && project.isOpen()) {
            result = project.getOrganization().findRoleById(this.id);
        }
        if (result == null) {
            throw new RuntimeException(ProjectModelMsg.PROJECT_OBJECT_NOT_AVAILABLE(ProjectObjectType.ORGANIZATION_ROLE.getMsg().getString(), this.id, this.projectId).getString());
        }
        return result;
    }
}

