/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.project.identity.MemberContainerImpl;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.project.model.organization.AssignableToRole;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.PotentialAssignee;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.organization.RoleAssignment;
import oracle.bpm.project.model.organization.RoleEscalation;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.organization.CalendarRuleAssignmentImpl;
import org.jetbrains.annotations.NotNull;

public class RoleImpl
extends MemberContainerImpl
implements Role,
ProjectObject.Mutable {
    private Collection<CalendarRuleAssignment> calendarRuleAssignments;
    private StringFeature description = StringFeature.create("description", ProjectMsg.DESCRIPTION, null, "");
    private LocaleStringMap map;
    private String name;
    private Organization organization;
    private PotentialAssignee potentialAssignee;
    private Collection<RoleAssignment> roleAssignments;
    private RoleEscalation roleEscalation;
    private boolean shared = false;

    public RoleImpl(Organization organization, String id, String name) {
        super(organization.getProject());
        this.organization = organization;
        this.calendarRuleAssignments = new ArrayList<CalendarRuleAssignment>();
        this.roleAssignments = new ArrayList<RoleAssignment>();
        this.id = id;
        this.name = name;
        this.addCalendarRuleProjectListener();
        this.addOUProjectListener();
    }

    @Override
    public void setDescription(String description) {
        String prev = this.description.getValue();
        this.description.setValue(description == null ? "" : description);
        this.events().objectChanged(this.description.getName(), prev, description);
    }

    @Override
    public String getDescription() {
        return this.description.getValue();
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.ORGANIZATION_ROLE;
    }

    @Override
    public boolean isVirtual() {
        return this.getId().equals("AutomaticHandler");
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = Path.ROLE.create(this.getId());
        }
        return this.path;
    }

    @Override
    public Collection<CalendarRuleAssignment> getCalendarRuleAssignment() {
        return this.calendarRuleAssignments;
    }

    @Override
    public void addCalendarRuleAssignment(CalendarRuleAssignment calendarRuleAssignment) {
        this.calendarRuleAssignments.add(calendarRuleAssignment);
        this.events().objectChanged("calendarRuleAssignment", null, calendarRuleAssignment);
    }

    @Override
    public void removeCalendarRuleAssignment(CalendarRuleAssignment calendarRuleAssignment) {
        this.calendarRuleAssignments.remove(calendarRuleAssignment);
        this.events().objectChanged("calendarRuleAssignment", calendarRuleAssignment, null);
    }

    @Override
    public CalendarRuleAssignment.Mutable createCalendarRuleAssignment() {
        CalendarRuleAssignmentImpl result = new CalendarRuleAssignmentImpl();
        result.setRole(this);
        return result;
    }

    @Override
    public boolean isDeletable() {
        return super.isDeletable() && !this.isProcessOwner();
    }

    @Override
    public void setCalendarRuleAssignment(Collection<CalendarRuleAssignment> calendarRuleAssignments) {
        this.calendarRuleAssignments = CollectionUtils.createCopy(calendarRuleAssignments);
        this.events().objectChanged("calendarRuleAssignment", null, calendarRuleAssignments);
    }

    @Override
    public void addRoleAssignment(RoleAssignment roleAssignment) {
        if (!this.roleAssignments.contains(roleAssignment)) {
            this.roleAssignments.add(roleAssignment);
        }
    }

    @Override
    public void removeRoleAssignment(RoleAssignment roleAssignment) {
        this.roleAssignments.remove(roleAssignment);
    }

    @Override
    public AssignableToRole findAssignedObject(String assignedObjectId) {
        for (RoleAssignment roleAssignment : this.roleAssignments) {
            if (!roleAssignment.getAssignedObject().getId().equals(assignedObjectId)) continue;
            return roleAssignment.getAssignedObject();
        }
        return null;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.events().objectChanged();
    }

    @Override
    public void setShared(boolean shared) {
        if (this.isProcessOwner() && shared) {
            throw new IllegalArgumentException("Trying to share Process Owner role: " + this.getId());
        }
        this.shared = shared;
        this.events().objectChanged();
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    @Override
    public RoleEscalation getRoleEscalation() {
        return this.roleEscalation;
    }

    @Override
    public void setRoleEscalation(RoleEscalation roleEscalation) {
        this.roleEscalation = roleEscalation;
        this.events().objectChanged();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<RoleAssignment> getRoleAssignments() {
        return this.roleAssignments;
    }

    @Override
    public int compareTo(Role o) {
        return this.getId().compareTo(o.getId());
    }

    @Override
    public void removeAllRoleAssignments() {
        this.roleAssignments.clear();
    }

    @Override
    public boolean isProcessOwner() {
        return this.getId().equals("ProcessOwner");
    }

    @Override
    public void removeCalendarRuleAssignments(CalendarRule calendarRule) {
        for (CalendarRuleAssignment cra : CollectionUtils.createCopy(this.getCalendarRuleAssignment())) {
            if (!cra.getCalendarRule().equals(calendarRule)) continue;
            this.removeCalendarRuleAssignment(cra);
        }
    }

    @Override
    public void removeCalendarRuleAssignments(OrganizationalUnit ou) {
        for (CalendarRuleAssignment cra : CollectionUtils.createCopy(this.getCalendarRuleAssignment())) {
            if (!ou.equals(cra.getOrganizationalUnit())) continue;
            this.removeCalendarRuleAssignment(cra);
        }
    }

    @Override
    public PotentialAssignee getPotentialAssignee() {
        return this.potentialAssignee;
    }

    @Override
    public void setPotentialAssignee(PotentialAssignee potentialAssignee) {
        this.potentialAssignee = potentialAssignee;
    }

    @Override
    public boolean isReferencedByProcesses() {
        if (this.getProject() == null) {
            return false;
        }
        Collection<Process> models = this.getProject().getProcesses();
        for (Process model : models) {
            if (LaneUtils.getLaneForRoleId(model, this.getId()) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public LocaleStringMap getLabelMap() {
        if (this.map == null) {
            this.map = LocaleStringMap.create();
        }
        return this.map;
    }

    @Override
    public String getDefaultLabel() {
        return this.getString(this.getLabelMap(), this.getName());
    }

    @Override
    public String getLabel(Locale locale) {
        return this.getLabelMap().getString(locale);
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getOrganization();
    }

    @Override
    public Organization getOrganization() {
        return this.organization;
    }

    private void addOUProjectListener() {
        ProjectListenerAdapter<OrganizationalUnit> ouProjectListener = new ProjectListenerAdapter<OrganizationalUnit>(OrganizationalUnit.class){

            @Override
            public void postObjectRemoved(OrganizationalUnit object, ProjectObject parent) {
                for (CalendarRuleAssignment cra : CollectionUtils.createCopy(RoleImpl.this.getCalendarRuleAssignment())) {
                    if (!object.equals(cra.getOrganizationalUnit())) continue;
                    RoleImpl.this.removeCalendarRuleAssignment(cra);
                }
            }
        };
        this.getOrganization().addListener(ouProjectListener);
    }

    private void addCalendarRuleProjectListener() {
        ProjectListenerAdapter<CalendarRule> crListener = new ProjectListenerAdapter<CalendarRule>(CalendarRule.class){

            @Override
            public void postObjectRemoved(CalendarRule object, ProjectObject parent) {
                for (CalendarRuleAssignment cra : CollectionUtils.createCopy(RoleImpl.this.getCalendarRuleAssignment())) {
                    if (!object.equals(cra.getCalendarRule())) continue;
                    RoleImpl.this.removeCalendarRuleAssignment(cra);
                }
            }
        };
        this.getOrganization().addListener(crListener);
    }
}

