/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.collections.lists.IntArrayList;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectManager;
import oracle.bpm.project.model.ProjectObjectRelation;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.impl.keys.ProjectObjectKey;

public class ReferenceManager
implements ProjectObjectManager {
    private ProjectObjectManager objectManager;
    private Map<String, IntArrayList> references;
    private ArrayList<ProjectObjectRelation> relations = new ArrayList();

    public ReferenceManager(ProjectObjectManager objectManager) {
        this.references = new HashMap<String, IntArrayList>();
        this.objectManager = objectManager;
    }

    @Override
    public void addRelation(ProjectObjectRelation relation) {
        this.relations.add(relation);
        int index = this.relations.indexOf(relation);
        Collection<ProjectObject> objects = relation.getRelation();
        for (ProjectObject projectObject : objects) {
            String key = projectObject.getId();
            if (!this.references.containsKey(key)) {
                this.references.put(key, new IntArrayList());
            }
            IntArrayList indices = this.references.get(key);
            indices.add(index);
        }
    }

    @Override
    public void removeRelation(ProjectObjectRelation relation) {
        int index = this.relations.indexOf(relation);
        Collection<ProjectObject> objects = relation.getRelation();
        for (ProjectObject projectObject : objects) {
            String key = projectObject.getId();
            IntArrayList indices = this.references.get(key);
            assert (indices != null);
            indices.remove(indices.indexOf(index));
            if (!indices.isEmpty()) continue;
            this.references.remove(key);
        }
        this.relations.remove(index);
    }

    @Override
    public Collection<ProjectObjectRelation> getRelations(ProjectObject object) {
        ArrayList<ProjectObjectRelation> result = new ArrayList<ProjectObjectRelation>();
        IntArrayList indices = this.references.get(object.getId());
        if (indices != null) {
            for (int i : indices.getNativeArray()) {
                result.add(this.relations.get(i));
            }
        }
        return result;
    }

    @Override
    public void addObject(ProjectObject object) {
        this.objectManager.addObject(object);
    }

    @Override
    public ProjectObject removeObject(ProjectObjectKey objectKey) throws ProjectException {
        return this.objectManager.removeObject(objectKey);
    }

    @Override
    public boolean contains(ProjectObject object) {
        return this.objectManager.contains(object);
    }

    @Override
    public boolean contains(ProjectObjectRelation relation) {
        return this.relations.contains(relation);
    }
}

