/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.TimeZone;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.features.BooleanFeature;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.GroupAssignment;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.ParticipantAbsence;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.organization.RoleAssignment;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.organization.GroupAssignmentImpl;
import oracle.bpm.project.organization.OrganizationObjectImpl;
import oracle.bpm.project.organization.ParticipantAbsenceImpl;
import oracle.bpm.project.organization.RoleAssignmentImpl;
import org.jetbrains.annotations.NotNull;

public class ParticipantImpl
extends OrganizationObjectImpl
implements Participant.Mutable {
    private Collection<ParticipantAbsence> absencePeriods;
    private double cost;
    private StringFeature displayName = StringFeature.create("description", ProjectMsg.DESCRIPTION, null, "");
    private int efficiency = 80;
    private StringFeature employeeId = StringFeature.create("employeeId", ProjectMsg.EMPLOYEE_ID, null, "");
    private StringFeature fax = StringFeature.create("fax", ProjectMsg.FAX, null, "");
    private StringFeature firstName = StringFeature.create("firstName", ProjectMsg.FIRST_NAME, null, "");
    private Collection<GroupAssignment> groupAssignments;
    private BooleanFeature isAdministrator = BooleanFeature.create("isAdministrator", ProjectMsg.IS_ADMINISTRATOR, null, false);
    private BooleanFeature isEnabled = BooleanFeature.create("isEnabled", ProjectMsg.IS_ENABLED, null, true);
    private StringFeature lastName = StringFeature.create("lastName", ProjectMsg.LAST_NAME, null, "");
    private Locale locale;
    private StringFeature mail = StringFeature.create("mail", ProjectMsg.MAIL, null, "");
    private StringFeature manager = StringFeature.create("manager", ProjectMsg.MANAGER, null, "");
    private OrganizationalUnit organizationalUnit = null;
    private String ouId;
    private byte[] photo;
    private BooleanFeature receivesMail = BooleanFeature.create("receivesMail", ProjectMsg.RECEIVES_MAIL, null, false);
    private Collection<ParticipantAbsence> replacementPeriods;
    private Collection<RoleAssignment> roleAssignments;
    private StringFeature telephone = StringFeature.create("telephone", ProjectMsg.TELEPHONE, null, "");
    private TimeZone timeZone;

    public ParticipantImpl(Organization organization) {
        super(organization);
        this.roleAssignments = new ArrayList<RoleAssignment>();
        this.groupAssignments = new ArrayList<GroupAssignment>();
        this.absencePeriods = new ArrayList<ParticipantAbsence>();
        this.replacementPeriods = new ArrayList<ParticipantAbsence>();
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = Path.PARTICIPANT.create(this.getId());
        }
        return this.path;
    }

    @Override
    public void setPhoto(byte[] photo) {
        this.photo = photo;
    }

    @Override
    public boolean receivesMail() {
        return this.receivesMail.getValue();
    }

    @Override
    public String getDisplayName() {
        return this.displayName == null ? this.getId() : this.displayName.getValue();
    }

    @Override
    public String getEmployeeId() {
        return this.employeeId.getValue();
    }

    @Override
    public String getFax() {
        return this.fax.getValue();
    }

    @Override
    public String getFirstName() {
        return this.firstName.getValue();
    }

    @Override
    public String getLastName() {
        return this.lastName.getValue();
    }

    @Override
    public String getMail() {
        return this.mail.getValue();
    }

    @Override
    public String getManager() {
        return this.manager.getValue();
    }

    @Override
    public OrganizationalUnit getOrganizationalUnit() {
        if (this.organizationalUnit == null) {
            this.organizationalUnit = this.ouId == null || "".equals(this.ouId) ? this.getOrganization().getRootOrganizationalUnit() : this.getOrganization().findOrganizationalUnit(this.ouId);
        }
        return this.organizationalUnit;
    }

    @Override
    public String getTelephone() {
        return this.telephone.getValue();
    }

    @Override
    public Collection<ParticipantAbsence> getAbsencePeriods() {
        return this.absencePeriods;
    }

    @Override
    public Collection<RoleAssignment> getRoleAssignments() {
        for (RoleAssignment roleAssignment : this.roleAssignments) {
            if (roleAssignment.getRole() != null || this.getOrganization().findRoleById(roleAssignment.getRoleId()) == null) continue;
            roleAssignment.asMutable().setRole(this.getOrganization().findRoleById(roleAssignment.getRoleId()));
            roleAssignment.addRelation();
        }
        return this.roleAssignments;
    }

    @Override
    public Collection<ParticipantAbsence> getReplacementPeriods() {
        return this.replacementPeriods;
    }

    @Override
    public boolean isAdministrator() {
        return this.isAdministrator.getValue();
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled.getValue();
    }

    @Override
    public byte[] getPhoto() {
        return this.photo;
    }

    @Override
    public Collection<GroupAssignment> getGroupAssignments() {
        for (GroupAssignment groupAssignment : this.groupAssignments) {
            if (groupAssignment.getGroup() != null || this.getOrganization().findGroup(groupAssignment.getGroupId()) == null) continue;
            groupAssignment.asMutable().setGroup(this.getOrganization().findGroup(groupAssignment.getGroupId()));
            groupAssignment.addRelation();
        }
        return this.groupAssignments;
    }

    @Override
    @NotNull
    public Participant.Mutable asMutable() {
        return this;
    }

    @Override
    public void setReceivesMail(boolean receivesMail) {
        boolean prevValue = this.receivesMail();
        this.receivesMail.setValue(receivesMail);
        this.events().objectChanged("receivesMail", prevValue, this.receivesMail());
    }

    @Override
    public void setDisplayName(String displayName) {
        String prevDisplayName = this.displayName.getValue();
        this.displayName.setValue(displayName == null ? "" : displayName);
        this.events().objectChanged("displayName", prevDisplayName, this.displayName.getValue());
    }

    @Override
    public void setEmployeeId(String employeeId) {
        String prevValue = this.employeeId.getValue();
        this.employeeId.setValue(employeeId == null ? "" : employeeId);
        this.events().objectChanged("employeeId", prevValue, this.employeeId.getValue());
    }

    @Override
    public void setFax(String fax) {
        String prevValue = this.fax.getValue();
        this.fax.setValue(fax == null ? "" : fax);
        this.events().objectChanged("fax", prevValue, this.fax.getValue());
    }

    @Override
    public void setFirstName(String firstName) {
        String prevValue = this.firstName.getValue();
        this.firstName.setValue(firstName == null ? "" : firstName);
        this.events().objectChanged("firstName", prevValue, this.firstName.getValue());
    }

    @Override
    public void setLastName(String lastName) {
        String prevValue = this.lastName.getValue();
        this.lastName.setValue(lastName == null ? "" : lastName);
        this.events().objectChanged("lastName", prevValue, this.lastName.getValue());
    }

    @Override
    public void setMail(String mail) {
        String prevMail = this.getMail();
        this.mail.setValue(mail == null ? "" : mail);
        this.events().objectChanged("mail", prevMail, this.mail);
    }

    @Override
    public void setManager(String manager) {
        String prevValue = this.manager.getValue();
        this.manager.setValue(manager == null ? "" : manager);
        this.events().objectChanged("manager", prevValue, this.manager.getValue());
    }

    @Override
    public void setOrganizationalUnit(OrganizationalUnit organizationalUnit) {
        OrganizationalUnit prevOu = this.getOrganizationalUnit();
        this.organizationalUnit = organizationalUnit;
        this.events().objectChanged("organizationalUnit", prevOu, organizationalUnit);
    }

    @Override
    public void setTelephone(String telephone) {
        String prevValue = this.telephone.getValue();
        this.telephone.setValue(telephone == null ? "" : telephone);
        this.events().objectChanged("telephone", prevValue, this.telephone.getValue());
    }

    @Override
    public ParticipantAbsence.Mutable createAbsencePeriod() {
        ParticipantAbsenceImpl result = new ParticipantAbsenceImpl();
        result.setParticipant(this);
        return result;
    }

    @Override
    public void addAbsencePeriod(ParticipantAbsence absence) {
        this.absencePeriods.add(absence);
    }

    @Override
    public void removeAbsencePeriod(ParticipantAbsence absence) {
        this.absencePeriods.remove(absence);
    }

    @Override
    public void setAdministrator(boolean isAdministrator) {
        boolean prevValue = this.isAdministrator();
        this.isAdministrator.setValue(isAdministrator);
        this.events().objectChanged("isAdministrator", prevValue, this.isAdministrator());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean prevValue = this.isEnabled();
        this.isEnabled.setValue(isEnabled);
        this.events().objectChanged("isEnabled", prevValue, this.isEnabled());
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.PARTICIPANT;
    }

    @Override
    public RoleAssignment.Mutable createRoleAssignment() {
        RoleAssignmentImpl result = new RoleAssignmentImpl();
        result.setAssignedObject(this);
        return result;
    }

    @Override
    public void addRoleAssignment(RoleAssignment roleAssignment) {
        if (!this.roleAssignments.contains(roleAssignment)) {
            this.roleAssignments.add(roleAssignment);
        }
        this.events().objectChanged("roleAssignment", null, roleAssignment);
    }

    @Override
    public void removeRoleAssignment(RoleAssignment roleAssignment) {
        this.roleAssignments.remove(roleAssignment);
    }

    @Override
    public void removeRole(Role role) {
        for (RoleAssignment roleAssignment : this.getRoleAssignments()) {
            if (!roleAssignment.getRole().equals(role)) continue;
            roleAssignment.removeRelation();
            break;
        }
    }

    @Override
    public Role findAssignedRole(String roleId) {
        for (RoleAssignment roleAssignment : this.getRoleAssignments()) {
            if (!roleAssignment.getRole().getId().equals(roleId)) continue;
            return roleAssignment.getRole();
        }
        return null;
    }

    @Override
    public Group findAssignedGroup(String groupId) {
        for (GroupAssignment groupAssignment : this.getGroupAssignments()) {
            if (!groupAssignment.getGroup().getId().equals(groupId)) continue;
            return groupAssignment.getGroup();
        }
        return null;
    }

    @Override
    public void removeGroup(Group group) {
        for (GroupAssignment groupAssignment : this.getGroupAssignments()) {
            if (!groupAssignment.getGroup().equals(group)) continue;
            groupAssignment.removeRelation();
            break;
        }
    }

    @Override
    public GroupAssignment.Mutable createGroupAssignment() {
        GroupAssignmentImpl result = new GroupAssignmentImpl();
        result.setAssignedObject(this);
        return result;
    }

    @Override
    public void addGroupAssignment(GroupAssignment groupAssignment) {
        this.groupAssignments.add(groupAssignment);
    }

    @Override
    public void removeGroupAssignment(GroupAssignment groupAssignment) {
        this.groupAssignments.remove(groupAssignment);
    }

    @Override
    public void addReplacementPeriod(ParticipantAbsence absence) {
        this.replacementPeriods.add(absence);
    }

    @Override
    public void removeReplacementPeriod(ParticipantAbsence absence) {
        this.replacementPeriods.remove(absence);
    }

    @Override
    public void addGroup(Group group) {
        GroupAssignment.Mutable groupAssignment = this.createGroupAssignment();
        groupAssignment.setGroup(group);
        groupAssignment.addRelation();
    }

    @Override
    public void setLocale(Locale locale) {
        Locale prevLocale = this.locale;
        this.locale = locale;
        this.events().objectChanged("locale", prevLocale, this.locale);
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        TimeZone prevTimeZone = this.timeZone;
        this.timeZone = timeZone;
        this.events().objectChanged("timeZone", prevTimeZone, timeZone);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void removeAllGroupAssignments(Collection<GroupAssignment> assignments) {
        this.groupAssignments.removeAll(assignments);
    }

    @Override
    public void removeOrganizationalUnit() {
        this.organizationalUnit = null;
        this.ouId = null;
    }

    @Override
    public void clearRoleAssignments() {
        this.roleAssignments.clear();
    }

    @Override
    public void clearGroupAssignments() {
        this.groupAssignments.clear();
    }

    @Override
    public void setOrganizationalUnitId(String ouPath) {
        this.ouId = ouPath;
    }

    @Override
    public void setCost(double cost) {
        this.cost = cost;
    }

    @Override
    public void setEfficiency(int efficiency) {
        this.efficiency = efficiency;
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public int getEfficiency() {
        return this.efficiency;
    }

    @Override
    public int compareTo(Participant participant) {
        return this.getId().compareTo(participant.getId());
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getOrganization().getParticipantsContainer();
    }
}

