/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.model.variables.BusinessParameter;
import oracle.bpm.project.model.variables.DefaultValueAssignment;

public class DefaultValueAssignmentImpl
implements DefaultValueAssignment.Mutable {
    private BusinessParameter businessParameter;
    private Object defaultValue;
    private OrganizationalUnit organizationalUnit;
    private String organizationalUnitId;

    @Override
    public BusinessParameter getBusinessParameter() {
        return this.businessParameter;
    }

    @Override
    public OrganizationalUnit getOrganizationalUnit() {
        if (this.organizationalUnit == null) {
            Organization organization = this.businessParameter.getProject().getOrganization();
            this.organizationalUnit = this.organizationalUnitId == null ? organization.getRootOrganizationalUnit() : organization.findOrganizationalUnit(this.organizationalUnitId);
        }
        return this.organizationalUnit;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public DefaultValueAssignment.Mutable asMutable() {
        return this;
    }

    @Override
    public Collection<ProjectObject> getRelation() {
        ArrayList<ProjectObject> result = new ArrayList<ProjectObject>();
        result.add(this.businessParameter);
        result.add(this.organizationalUnit);
        return result;
    }

    @Override
    public void addRelation() {
        this.businessParameter.asMutable().addDefaultValueAssignment(this);
        this.organizationalUnit.asMutable().addDefaultValueAssignment(this);
    }

    @Override
    public void removeRelation() {
        this.businessParameter.asMutable().removeDefaultValueAssignment(this);
        this.organizationalUnit.asMutable().removeDefaultValueAssignment(this);
    }

    @Override
    public void setBusinessParameter(BusinessParameter businessParameter) {
        this.businessParameter = businessParameter;
    }

    @Override
    public void setOrganizationalUnit(OrganizationalUnit ou) {
        this.organizationalUnit = ou;
    }

    @Override
    public void setOrganizationalUnitId(String id) {
        this.organizationalUnitId = id;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }
}

