/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.organization;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.lang.Day;
import oracle.bpm.lang.WorkWeek;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.project.model.organization.CalendarRule;
import oracle.bpm.project.model.organization.CalendarRuleAssignment;
import oracle.bpm.project.model.organization.HolidayRuleAssignment;
import oracle.bpm.project.model.organization.OrganizationalUnit;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.organization.CalendarRuleAssignmentImpl;
import oracle.bpm.project.organization.HolidayRuleAssignmentImpl;
import oracle.bpm.project.organization.OrganizationObjectImpl;
import oracle.bpm.util.TimeZones;
import org.jetbrains.annotations.NotNull;

public class CalendarRuleImpl
extends OrganizationObjectImpl
implements CalendarRule.Mutable {
    private Collection<CalendarRuleAssignment> calendarRuleAssignments;
    private HolidayRuleAssignment holidayRuleAssignment;
    private StringFeature timeZone = StringFeature.create("timeZone", ProjectMsg.TIME_ZONE, null, "");
    private WorkWeek workWeek;

    public CalendarRuleImpl(Organization organization) {
        super(organization);
        this.calendarRuleAssignments = new ArrayList<CalendarRuleAssignment>();
        this.workWeek = WorkWeek.getDefault();
        this.timeZone.setValue(TimeZones.getDefault());
    }

    @Override
    @NotNull
    public CalendarRule.Mutable asMutable() {
        return this;
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            this.path = Path.CALENDAR.create(this.getId());
        }
        return this.path;
    }

    @Override
    public void setTimeZone(String timeZone) {
        String prevTimeZone = this.getTimeZone();
        this.timeZone.setValue(timeZone);
        this.events().objectChanged(this.getOrganization(), "timeZone", prevTimeZone, this.timeZone.getValue());
    }

    @Override
    public void setWorkWeek(WorkWeek workWeek) {
        WorkWeek prevWorkWeek = this.workWeek;
        this.workWeek = workWeek;
        this.events().objectChanged(this.getOrganization(), "workWeek", prevWorkWeek, this.workWeek);
    }

    @Override
    public String getTimeZone() {
        return this.timeZone.getValue();
    }

    @Override
    public void addHolidayRuleAssignment(HolidayRuleAssignment holidayRuleAssignment) {
        HolidayRuleAssignment prevHolidayRuleAssignment = this.holidayRuleAssignment;
        this.holidayRuleAssignment = holidayRuleAssignment;
        this.events().objectChanged(this.getOrganization(), "holidayRuleAssignment", prevHolidayRuleAssignment, this.holidayRuleAssignment);
    }

    @Override
    public void setHolidayRule(String holidayRuleId) {
        HolidayRuleAssignment.Mutable holidayRuleAssignment = this.createHolidayRuleAssignment().asMutable();
        holidayRuleAssignment.setHolidayRule(holidayRuleId);
        this.addHolidayRuleAssignment(holidayRuleAssignment);
    }

    @Override
    public WorkWeek getWorkWeek() {
        return this.workWeek;
    }

    @Override
    public Collection<OrganizationalUnit> getOrganizationalUnits() {
        ArrayList<OrganizationalUnit> result = new ArrayList<OrganizationalUnit>();
        for (CalendarRuleAssignment calendarRuleAssignment : this.calendarRuleAssignments) {
            if (calendarRuleAssignment.getRole() != null) continue;
            result.add(calendarRuleAssignment.getOrganizationalUnit());
        }
        return result;
    }

    @Override
    public Collection<CalendarRuleAssignment> getCalendarRuleAssignments() {
        return this.calendarRuleAssignments;
    }

    @Override
    public void addCalendarRuleAssignment(CalendarRuleAssignment calendarRuleAssignment) {
        this.calendarRuleAssignments.add(calendarRuleAssignment);
        this.events().objectChanged(this.getOrganization(), "calendarRuleAssignment", null, calendarRuleAssignment);
    }

    @Override
    public void removeCalendarRuleAssignment(CalendarRuleAssignment calendarRuleAssignment) {
        this.calendarRuleAssignments.remove(calendarRuleAssignment);
        this.events().objectChanged(this.getOrganization(), "calendarRuleAssignment", calendarRuleAssignment, null);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.CALENDAR_RULE;
    }

    @Override
    public boolean isWorkWeekScheduled() {
        for (Day day : Day.values()) {
            if (this.workWeek.getSchedule(day) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public HolidayRuleAssignment getHolidayRuleAssignment() {
        if (this.holidayRuleAssignment != null && this.holidayRuleAssignment.getHolidayRule() == null && this.getOrganization().findHolidayRule(this.holidayRuleAssignment.getHolidayRuleId()) != null) {
            this.holidayRuleAssignment.asMutable().setHolidayRule(this.getOrganization().findHolidayRule(this.holidayRuleAssignment.getHolidayRuleId()));
            this.holidayRuleAssignment.addRelation();
        }
        return this.holidayRuleAssignment;
    }

    @Override
    public void removeHolidayRuleAssignment(HolidayRuleAssignment holidayRuleAssignment) {
        this.holidayRuleAssignment = null;
        this.events().objectChanged(this.getOrganization(), "holidayRuleAssignment", holidayRuleAssignment, null);
    }

    @Override
    public HolidayRuleAssignment.Mutable createHolidayRuleAssignment() {
        HolidayRuleAssignmentImpl holidayRuleAssignment = new HolidayRuleAssignmentImpl();
        holidayRuleAssignment.asMutable().setAssignedObject(this);
        return holidayRuleAssignment.asMutable();
    }

    @Override
    public CalendarRuleAssignment.Mutable createCalendarRuleAssignment() {
        CalendarRuleAssignmentImpl calendarRuleAssignment = new CalendarRuleAssignmentImpl();
        calendarRuleAssignment.asMutable().setCalendarRule(this);
        return calendarRuleAssignment.asMutable();
    }

    @Override
    public CalendarRuleAssignment getCalendarRuleAssignment(String ouId) {
        for (CalendarRuleAssignment calendarRuleAssignment : this.getCalendarRuleAssignments()) {
            if (!calendarRuleAssignment.hasOuAssociated(ouId)) continue;
            return calendarRuleAssignment;
        }
        return null;
    }

    @Override
    public int compareTo(CalendarRule calendarRule) {
        return this.getId().compareTo(calendarRule.getId());
    }

    @Override
    public ProjectObject getParentObject() {
        return this.getOrganization();
    }
}

