/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.identity;

import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.identity.Member;
import oracle.bpm.project.model.identity.MemberType;
import org.jetbrains.annotations.NotNull;

public abstract class MemberImpl
extends ProjectObjectImpl
implements Member {
    private String name;
    private ProjectObject parentObject;
    private MemberType type;

    public MemberImpl(String id, MemberType type) {
        this(id, type, null);
    }

    public MemberImpl(String id, MemberType type, ProjectObject parentObject) {
        super(parentObject.getProject());
        this.type = type;
        this.setId(id);
        this.name = id;
        this.parentObject = parentObject;
    }

    @Override
    public MemberType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name != null ? this.name : this.getId();
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.setId(name);
    }

    @Override
    public ProjectObject getParentObject() {
        return this.parentObject;
    }

    @Override
    public void setParentObject(ProjectObject parentObject) {
        this.parentObject = parentObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemberImpl)) {
            return false;
        }
        MemberImpl member = (MemberImpl)o;
        if (!this.name.equals(member.name)) {
            return false;
        }
        return this.type == member.type;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

