/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.fixes;

import java.util.List;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.extension.Extension;
import oracle.bpm.extensionpoint.metadata.FixerExtensionPointMetadata;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.project.fixes.Fixer;
import oracle.bpm.project.fixes.FixerFixOptionAdapter;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.FixOption;
import oracle.bpm.util.Fixable;

public class FixRegistry {
    private static final FixOption[] EMPTY_FIX_OPTIONS = new FixOption[0];
    private static FixRegistry instance;

    private FixRegistry() {
    }

    public static synchronized FixRegistry getInstance() {
        if (instance == null) {
            instance = new FixRegistry();
        }
        return instance;
    }

    public FixOption[] getFixOptionsFor(Fixable exception) {
        if (exception == null) {
            return EMPTY_FIX_OPTIONS;
        }
        List<FixOption> options = CollectionFactory.createList();
        for (Extension<FixerExtensionPointMetadata> extension : this.getAvailableExtensions()) {
            if (!this.canFix(exception, extension)) continue;
            options.add(new FixerFixOptionAdapter(this.createFixer(extension), exception));
        }
        this.addExceptionInstrinsicOptions(options, exception);
        return options.toArray(EMPTY_FIX_OPTIONS);
    }

    public boolean isFixable(Exception exception) {
        return exception instanceof Fixable && (this.isIntrinsicallyFixable((Fixable)exception) || this.isExtrinsicallyFixable((Fixable)exception));
    }

    private void addExceptionInstrinsicOptions(List<FixOption> options, Fixable fixable) {
        FixOption[] fixOptions = fixable.getFixOptions();
        if (fixOptions != null) {
            for (FixOption option : fixOptions) {
                if (option == null) continue;
                options.add(option);
            }
        }
    }

    private Fixer createFixer(Extension<FixerExtensionPointMetadata> extension) {
        try {
            return extension.instantiateAs(Fixer.class);
        }
        catch (InstantiationException e) {
            throw new ProgramException("Error while instantiating " + FixerExtensionPointMetadata.class.getSimpleName() + " for exception " + extension.getMetadata().fixableType(), e);
        }
    }

    private boolean isExtrinsicallyFixable(Fixable exception) {
        for (Extension<FixerExtensionPointMetadata> extension : this.getAvailableExtensions()) {
            if (!this.canFix(exception, extension)) continue;
            return true;
        }
        return false;
    }

    private boolean canFix(Fixable fixable, Extension<FixerExtensionPointMetadata> extension) {
        return Any.equals(fixable.getClass().getName(), extension.getMetadata().fixableType());
    }

    private boolean isIntrinsicallyFixable(Fixable fixable) {
        return fixable.isFixable() && !ArrayUtils.isNullOrEmtpy(fixable.getFixOptions());
    }

    private List<Extension<FixerExtensionPointMetadata>> getAvailableExtensions() {
        return Platform.getExtensionService().getExtensionsByPoint(FixerExtensionPointMetadata.class);
    }
}

