/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.documentables;

import java.util.Collection;
import java.util.Locale;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.util.documentation.Documentable;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectObjectDocumentable
implements Documentable {
    private final ProjectObject projectObject;

    public ProjectObjectDocumentable(@NotNull ProjectObject projectObject) {
        this.projectObject = projectObject;
    }

    public boolean isEditable() {
        return !this.projectObject.isReadOnly();
    }

    public String getLabel() {
        return this.projectObject.getName();
    }

    public Collection<Locale> getAvailableLanguages() {
        return this.getProjectPreferences().getAvailableLanguages();
    }

    public Locale getDefaultLanguage() {
        return this.getProjectPreferences().getDefaultLanguage();
    }

    public ProjectObject getProjectObject() {
        return this.projectObject;
    }

    private Project getProject() {
        return this.getProjectObject().getProject();
    }

    private ProjectPreferences getProjectPreferences() {
        return this.getProject().getPreferences();
    }
}

