/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.documentables;

import java.util.Locale;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.documentables.ProjectObjectDocumentable;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.type.catalog.DocumentationProvider;
import oracle.bpm.util.documentation.Documentable;
import oracle.bpm.util.documentation.DocumentationType;

class CatalogTypeDocumentable
extends ProjectObjectDocumentable {
    protected CatalogTypeDocumentable(CatalogType catalogType) {
        super(catalogType);
    }

    public void setDocumentation(DocumentationType documentationType, Locale language, String doc) {
        String prevDoc = this.getDocumentation(documentationType, language);
        if (!Any.equals(prevDoc, doc)) {
            TypeDescription type = this.getType();
            if (doc != null) {
                type.setDocumentation(documentationType, language, doc);
            } else {
                type.getDocumentation(documentationType).remove(language);
            }
        }
    }

    public String getDocumentation(DocumentationType documentationType, Locale language) {
        TypeDescription type = this.getType();
        return this.isEditable() ? type.getDocumentation(documentationType, language) : DocumentationProvider.getInstance().getDocumentation(type, language);
    }

    @Override
    public String getLabel() {
        return this.getType().getQualifiedName();
    }

    @Override
    public CatalogType getProjectObject() {
        return (CatalogType)super.getProjectObject();
    }

    protected TypeDescription getType() {
        return this.getProjectObject().getDelegate();
    }

    static Documentable create(CatalogType catalogType) {
        return new CatalogTypeDocumentable(catalogType);
    }
}

