/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.differ;

import java.util.LinkedList;
import java.util.List;
import oracle.bpm.project.differ.ProjectObjectChange;
import oracle.bpm.project.differ.ProjectObjectChangeType;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.NodeContainer;
import org.jetbrains.annotations.NotNull;

public class ProjectObjectChangeSet
extends ProjectObjectChange {
    private List<ProjectObjectChange> changes;
    private List<ProjectObjectChangeSet> children;

    public ProjectObjectChangeSet(@NotNull ProjectObject object) {
        this(object, new LinkedList<ProjectObjectChange>(), new LinkedList<ProjectObjectChangeSet>());
    }

    private ProjectObjectChangeSet(@NotNull ProjectObject object, @NotNull List<ProjectObjectChange> changes, @NotNull List<ProjectObjectChangeSet> children) {
        super(object);
        this.changes = changes;
        this.children = children;
    }

    @Override
    public ProjectObjectChangeSet apply(@NotNull NodeContainer container) {
        throw new IllegalStateException("Oooooops! recursive apply!");
    }

    @Override
    public ProjectObjectChangeType getType() {
        return ProjectObjectChangeType.MODIFY;
    }

    public void append(@NotNull ProjectObjectChange change) {
        this.changes.add(change);
    }

    public void append(@NotNull ProjectObjectChangeSet change) {
        this.children.add(change);
    }

    public boolean isEmpty() {
        return this.changes.isEmpty() && this.children.isEmpty();
    }

    public Iterable<ProjectObjectChange> getChanges() {
        return this.changes;
    }

    public Iterable<ProjectObjectChangeSet> getChildren() {
        return this.children;
    }

    public String toString() {
        return this.getAffectedProjectObject().getName() + '(' + (Object)((Object)ProjectObjectChangeType.MODIFY) + ')';
    }
}

