/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compiler;

import oracle.bpm.bpmobject.design.BpmObjectTypeDescriptionHelper;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.compiler.CatalogObjectCompiler;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.msg.ProjectMsg;
import org.jetbrains.annotations.NotNull;

@CompilerExtensionMetadata
public class EnumCompiler
extends CatalogObjectCompiler {
    @Override
    public boolean supports(@NotNull CatalogObject object) {
        return object.getObjectType().getKind() == 17;
    }

    @Override
    public void compile(@NotNull CatalogObject object, @NotNull CompilationSession session) throws ProjectException {
        ObjectTypeDescription objectType = object.getObjectType();
        int memberCount = objectType.isBpmObject() ? BpmObjectTypeDescriptionHelper.getMemberCount((XObjectTypeDescription)objectType.asBpmObject()) : objectType.getMemberCount();
        if (memberCount == 0) {
            this.getListener().onError(new ProjectException(object, ProjectMsg.ENUM_HAS_NO_ITEMS));
        }
        super.compile(object, session);
    }
}

