/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compiler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.bpm.project.compiler.TypeDependencies;

public class CompilationOptions {
    private Set<String> addedTypes = Collections.emptySet();
    private Set<String> changedTypes = Collections.emptySet();
    private boolean compileBusinessObjects = true;
    private boolean compileIntrospectedObjects = true;
    private boolean compileModels = true;
    private boolean deploying;
    private boolean fullBuild = true;
    private TypeDependencies lastBuildDependencies;
    private boolean mustEmitCode = true;
    private Set<String> removedTypes = Collections.emptySet();
    private boolean traceEnabled = !Boolean.getBoolean("fuego.project.compiler.disableTrace");

    public boolean isDeploying() {
        return this.deploying;
    }

    public boolean isCompileBusinessObjects() {
        return this.compileBusinessObjects;
    }

    public void setCompileBusinessObjects(boolean compile) {
        this.compileBusinessObjects = compile;
    }

    public boolean isCompileIntrospectedObjects() {
        return this.compileIntrospectedObjects;
    }

    public void setCompileIntrospectedObjects(boolean compile) {
        this.compileIntrospectedObjects = compile;
    }

    public boolean isCompileModels() {
        return this.compileModels;
    }

    public void setCompileModels(boolean compile) {
        this.compileModels = compile;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    public boolean mustEmitCode() {
        return this.mustEmitCode;
    }

    public void setEmitCode(boolean emitCode) {
        this.mustEmitCode = emitCode;
    }

    public Set<String> getAddedTypes() {
        return this.addedTypes;
    }

    public void setAddedTypes(Set<String> addedTypes) {
        this.addedTypes = addedTypes;
    }

    public Set<String> getChangedTypes() {
        return this.changedTypes;
    }

    public void setChangedTypes(Set<String> changedTypes) {
        this.changedTypes = changedTypes;
    }

    public Set<String> getRemovedTypes() {
        return this.removedTypes;
    }

    public void setRemovedTypes(Set<String> removedTypes) {
        this.removedTypes = removedTypes;
    }

    public Set<String> getAffectedTypes() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.getAddedTypes());
        result.addAll(this.getChangedTypes());
        result.addAll(this.getRemovedTypes());
        return result;
    }

    public boolean isFullBuild() {
        return this.fullBuild;
    }

    public void setFullBuild(boolean fullBuild) {
        this.fullBuild = fullBuild;
    }

    public TypeDependencies getLastBuildDependencies() {
        if (this.lastBuildDependencies == null) {
            this.lastBuildDependencies = new TypeDependencies();
        }
        return this.lastBuildDependencies;
    }

    public void setLastBuildDependencies(TypeDependencies deps) {
        this.lastBuildDependencies = deps;
    }

    public void setDeploying(boolean value) {
        this.deploying = value;
    }
}

