/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compiler;

import java.util.Arrays;
import java.util.List;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.TypeError;
import oracle.bpm.project.compile.exceptions.CatalogObjectCompilerException;
import oracle.bpm.project.compiler.AbstractCompilerExtension;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NotNull;

@CompilerExtensionMetadata
public class CatalogObjectCompiler
extends AbstractCompilerExtension<CatalogObject> {
    public CatalogObjectCompiler() {
        super(CatalogObject.class, Arrays.asList(ProjectObjectType.BPM_OBJECT, ProjectObjectType.UNKNOWN));
    }

    @Override
    public boolean supports(@NotNull CatalogObject object) {
        return !ComponentType.CORRUPTED_RESOURCE.getText().equals(object.getDelegate().getComponentType());
    }

    @Override
    public void compile(@NotNull CatalogObject object, @NotNull CompilationSession session) throws ProjectException {
        ObjectTypeDescription typeDescription = (ObjectTypeDescription)object.getDelegate();
        this.verifyHasErrors(object, typeDescription);
        this.verifyAttributes(object, typeDescription);
        this.verifyMethods(object, typeDescription);
    }

    private void verifyHasErrors(@NotNull CatalogObject object, @NotNull ObjectTypeDescription typeDescription) throws CatalogObjectCompilerException {
        List errors = typeDescription.getErrors();
        if (!errors.isEmpty()) {
            TypeError typeError = (TypeError)errors.get(0);
            throw CatalogObjectCompilerException.createCatalogObjectWithErrors((CatalogObject)object, (TypeError)typeError);
        }
    }

    private void verifyAttributes(@NotNull CatalogObject object, ObjectTypeDescription typeDescription) throws ProjectException {
        List attributes = typeDescription.getAttributes();
        for (MethodTypeDescription methodTypeDescription : attributes) {
            AttributeTypeDescription attribute;
            TypeRef typeRef;
            if (!methodTypeDescription.isAttribute() || !(typeRef = (attribute = (AttributeTypeDescription)methodTypeDescription).getTypeRef()).get().isUnknown()) continue;
            throw CatalogObjectCompilerException.createInvalidAttribute((CatalogObject)object, (String)attribute.getName(), (TypeRef)typeRef);
        }
    }

    private void verifyMethods(@NotNull CatalogObject object, @NotNull ObjectTypeDescription typeDescription) throws ProjectException {
        List methods = typeDescription.getMethods();
        for (MethodTypeDescription method : methods) {
            Argument[] arguments;
            for (Argument argument : arguments = method.getArguments()) {
                TypeRef typeRef = argument.getTypeRef();
                TypeDescription argTypeRef = typeRef.get();
                if (!argTypeRef.isUnknown()) continue;
                throw CatalogObjectCompilerException.createMethodAttribute((CatalogObject)object, (String)method.getName(), (String)argument.getName(), (TypeRef)typeRef);
            }
        }
    }
}

