/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compiler;

import java.util.Arrays;
import oracle.bpm.extensionpoint.metadata.CompilerExtensionMetadata;
import oracle.bpm.project.compile.process.ProjectChecker;
import oracle.bpm.project.compiler.AbstractCompilerExtension;
import oracle.bpm.project.compiler.CompilationSession;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ProjectException;

@CompilerExtensionMetadata
public class BPMProjectCompiler
extends AbstractCompilerExtension<Project> {
    public BPMProjectCompiler() {
        super(Project.class, Arrays.asList(ProjectObjectType.PROJECT));
    }

    @Override
    public boolean supports(Project object) {
        return true;
    }

    @Override
    public void compile(Project project, CompilationSession session) throws ProjectException {
        ProjectMessageListener listener = new ProjectMessageListener(){

            @Override
            public void reportError(ProjectObject object, ProjectException exception) {
                BPMProjectCompiler.this.reportError(exception.getMsg(), object);
            }

            @Override
            public void reportWarning(ProjectObject object, ProjectException exception) {
                BPMProjectCompiler.this.reportWarning(exception.getMsg(), object);
            }
        };
        ProjectChecker projectChecker = new ProjectChecker(project, listener);
        projectChecker.check();
    }
}

