/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.builder;

import java.util.LinkedHashMap;
import java.util.Map;
import oracle.bpm.io.IndentedPrintWriter;
import oracle.bpm.project.builder.Builder;
import oracle.bpm.project.builder.Tokens;

public abstract class ExprBuilder
extends Builder {
    private Map assignMap = new LinkedHashMap();

    public ExprBuilder(Tokens tokens) {
        super(tokens);
    }

    public void addAssign(String lvalue, String rvalue) {
        this.assignMap.put(new LV(lvalue, true), new RV(rvalue, false));
    }

    public void addAssign(String lvalue, boolean generateLeftThis, String rvalue, boolean generateRightThis) {
        this.assignMap.put(new LV(lvalue, generateLeftThis), new RV(rvalue, generateRightThis));
    }

    public void generateArray(String[] values, IndentedPrintWriter pw) {
        pw.print(this.getArrayOpen());
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            if (i != 0) {
                pw.print(", ");
            }
            pw.print(value);
        }
        pw.print(this.getArrayClose());
    }

    public void generateAssignStatements(IndentedPrintWriter pw) {
        for (Map.Entry entry : this.assignMap.entrySet()) {
            LV lvalue = (LV)entry.getKey();
            RV rvalue = (RV)entry.getValue();
            if (lvalue.generateThis) {
                pw.print(this.getThis());
                pw.print('.');
            }
            pw.print(lvalue.value);
            pw.print(" = ");
            if (rvalue.generateThis) {
                pw.print(this.getThis());
                pw.print('.');
            }
            pw.print(rvalue.value);
            pw.println(this.getStatementSeparator());
        }
    }

    private static class RV {
        private boolean generateThis;
        private String value;

        RV(String rval, boolean generateThis) {
            this.value = rval;
            this.generateThis = generateThis;
        }
    }

    private static class LV {
        boolean generateThis;
        String value;

        LV(String lval, boolean generateThis) {
            this.value = lval;
            this.generateThis = generateThis;
        }
    }

    public static class VisualBasic
    extends ExprBuilder {
        public VisualBasic() {
            super(VISUALBASIC_TOKENS);
        }

        @Override
        public String getLanguage() {
            return "VisualBasic";
        }
    }

    public static class Java
    extends ExprBuilder {
        public Java() {
            super(JAVA_TOKENS);
        }

        @Override
        public String getLanguage() {
            return "Java";
        }
    }

    public static class Fuego
    extends ExprBuilder {
        public Fuego() {
            super(FUEGO_TOKENS);
        }

        @Override
        public String getLanguage() {
            return "Fuego";
        }
    }
}

