/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.activityguide;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.activityguide.ActivityGuide;
import oracle.bpm.project.model.activityguide.ResourceBundle;

public class ResourceBundleImpl
implements ResourceBundle {
    private boolean external = false;
    private String location;
    private String name;
    private Map<String, String> resources = new TreeMap<String, String>();
    public static final String DEFAULT_RESOURCE_BUNDLE_NAME = "ActivityGuide";
    public static final String DEFAULT_RESOURCE_BUNDLE_LOCATION = "";

    public ResourceBundleImpl(String name) {
        this(name, DEFAULT_RESOURCE_BUNDLE_LOCATION);
    }

    public ResourceBundleImpl(String name, String location) {
        this.name = name;
        this.location = location;
    }

    public static ResourceBundle createDefault() {
        ResourceBundleImpl resourceBundle = new ResourceBundleImpl(DEFAULT_RESOURCE_BUNDLE_NAME, DEFAULT_RESOURCE_BUNDLE_LOCATION);
        resourceBundle.setExternal(false);
        return resourceBundle;
    }

    public static String getDefaultResourceBundle() {
        return Str.isEmpty(DEFAULT_RESOURCE_BUNDLE_LOCATION) ? DEFAULT_RESOURCE_BUNDLE_NAME : "/ActivityGuide";
    }

    public static String getResourceBundle(ActivityGuide activityGuide) {
        return Str.isEmpty(activityGuide.getResourceBundle().getLocation()) ? activityGuide.getResourceBundle().getName() : activityGuide.getResourceBundle().getLocation() + "/" + activityGuide.getResourceBundle().getName();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public Collection<String> getKeys() {
        return this.resources.keySet();
    }

    @Override
    public String getValue(String key) {
        return this.resources.get(key);
    }

    @Override
    public void add(String key, String value) {
        this.resources.put(key, value);
    }

    @Override
    public boolean isExternal() {
        return this.external;
    }

    @Override
    public void setExternal(boolean isExternal) {
        this.external = isExternal;
    }
}

