/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.activityguide;

import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.activityguide.ActivityRef;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class ActivityRefImpl
extends ProjectObjectImpl
implements ActivityRef {
    private String activityId;
    private String processId;
    private Project project;

    public ActivityRefImpl(@NotNull Activity activity) {
        this(activity.getProcess().getId(), activity.getId());
    }

    public ActivityRefImpl(@NotNull String processId, @NotNull String activityId) {
        this.setId(activityId);
        this.project = this.project;
        this.activityId = activityId;
        this.processId = processId;
    }

    @Override
    public Process getProcess(@NotNull Project project) {
        return project.findProcess(this.processId);
    }

    @Override
    public Activity getActivity(@NotNull Project project) {
        if (this.getProcess(project) != null) {
            return this.getProcess(project).findDescendant(Activity.class, this.activityId);
        }
        return null;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    @Override
    public String getProcessId() {
        return this.processId;
    }
}

