/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.activities;

import oracle.bpm.lang.Any;
import oracle.bpm.project.model.features.NonPersistentFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.resources.Msg;

public class ProcessActivityFeature
extends NonPersistentFeature<String> {
    private String prevValue;
    private String value;

    public ProcessActivityFeature(String featureName, Msg label, Msg description, String value) {
        super(featureName, label, description);
        this.value = value;
    }

    public static ProcessActivityFeature create() {
        return new ProcessActivityFeature("processActivity", ProjectModelMsg.BPEL_PROCESS_ACTIVITY, null, null);
    }

    public static ProcessActivityFeature create(String name) {
        return new ProcessActivityFeature("processActivity", ProjectModelMsg.BPEL_PROCESS_ACTIVITY, null, name);
    }

    @Override
    public void setValue(String value) {
        boolean fire = false;
        if (!Any.equals(this.value, value)) {
            this.prevValue = this.value;
            fire = true;
        }
        this.value = value;
        if (fire) {
            this.fireChanged();
        }
    }

    @Override
    public String getPrevValue() {
        return this.prevValue;
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

