/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.project.ProjectObjectContainerImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.events.BatchProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.exception.ProjectException;
import org.jetbrains.annotations.Nullable;

public class ResourceObjectImpl
extends ProjectObjectContainerImpl
implements ResourceObject {
    private boolean dirty;
    private boolean ignoreDirty;
    private static final String DIRTY = "dirty";

    public ResourceObjectImpl(Project project) {
        super(project);
        this.addListener(new BatchProjectListenerAdapter<ProjectObject>(ProjectObject.class){

            @Override
            public void processPostEvents(ProjectEventSet events) {
                if (!ResourceObjectImpl.this.ignoreDirty) {
                    ResourceObjectImpl.this.dirty = true;
                }
            }
        });
    }

    public static ProjectObject copy(ResourceObject resourceObject) {
        try {
            String xmlProjectObject = resourceObject.asXml();
            return resourceObject.getProject().getLoader().createFromXml(resourceObject.getClass(), xmlProjectObject);
        }
        catch (ProjectException e) {
            ProgramException.wrap("Problems while copying project object: " + resourceObject.getId(), e);
            return null;
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDirty(boolean dirty) {
        if (dirty != this.dirty) {
            this.dirty = dirty;
            try {
                this.ignoreDirty = true;
                this.events().objectChanged(DIRTY, !dirty, dirty);
            }
            finally {
                this.ignoreDirty = false;
            }
        }
    }

    @Override
    @Nullable
    public ProjectObject copy() {
        return ResourceObjectImpl.copy(this);
    }
}

