/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.ApplicationInfoImpl;
import oracle.bpm.project.CorrelationKeyContainerManager;
import oracle.bpm.project.DataDeclarationImpl;
import oracle.bpm.project.FeaturesByProcess;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.NodeContainerManager;
import oracle.bpm.project.PredefinedVariablesHelper;
import oracle.bpm.project.ProcessArgumentContainer;
import oracle.bpm.project.ResourceObjectImpl;
import oracle.bpm.project.TextAnnotationImpl;
import oracle.bpm.project.compile.process.ConversationalHelper;
import oracle.bpm.project.model.CorrelationKey;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.ModificationAwareLocaleStringMap;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectList;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.AnalyticsViewIdentifierFeature;
import oracle.bpm.project.model.features.AnnotationsFeature;
import oracle.bpm.project.model.features.AuthorFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.FileRevisionFeature;
import oracle.bpm.project.model.features.InputArgumentsFeature;
import oracle.bpm.project.model.features.NamespaceFeature;
import oracle.bpm.project.model.features.OutputArgumentsFeature;
import oracle.bpm.project.model.features.ProcessSealTypeFeature;
import oracle.bpm.project.model.features.SuspendInstanceOnDataAssociationErrorFeature;
import oracle.bpm.project.model.features.XmlnsFeature;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.ApplicationInfo;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.InclusiveGateway;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.ModelObject;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.ParallelGateway;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ProcessGenerateEvents;
import oracle.bpm.project.model.processes.ProcessSealType;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.activities.ProcessGenerateEventsFeature;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationContainer;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversation.DefineInterfaceConversationDefinition;
import oracle.bpm.project.model.processes.conversational.DefineInterfaceConversationalDefinition;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.process.conversation.ConversationImpl;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.Variable;
import oracle.bpm.util.PublishUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessContent
extends ResourceObjectImpl
implements Cloneable,
ModelObject,
Localizable.Mutable,
Process {
    protected ProcessGenerateEvents generatesEvents = ProcessGenerateEvents.GENERATE_INTERACTIVE_EVENTS;
    protected boolean storing;
    private ComponentCatalog catalog;
    private ResourceContainer container;
    private ModificationAwareLocaleStringMap documentation;
    private ModificationAwareLocaleStringMap useCaseDocumentation;
    private Features features;
    private LocaleStringMap label;
    private LocaleStringMap description;
    @NotNull
    private final NavigableMap<Integer, Lane> lanes = new TreeMap<Integer, Lane>();
    private boolean measurementsChanged = false;
    private final NodeContainerManager nodeContainerManager;
    protected static final int BEGIN_END_ROLE_WIDTH = 450;
    public static final long INSTANCE_SERIAL_VERSION = 0xFEFEFEFEL;

    public ProcessContent(ResourceContainer container, ComponentCatalog componentCatalog) {
        super(container != null ? container.getProject() : null);
        this.container = container;
        this.catalog = componentCatalog;
        this.nodeContainerManager = new NodeContainerManager(this);
        this.init();
        this.label = this.createLocaleStringMap("process.label");
    }

    public static Variable createCILVariable() {
        return new Variable("", (TypeRef)TypeFactory.getAny());
    }

    @Override
    public Class getRawClass() {
        return Process.class;
    }

    @Override
    public void removeChild(ProjectObject child) throws ProjectException {
        if (child instanceof Lane) {
            this.removeLane((Lane)child);
        } else {
            super.removeChild(child);
        }
    }

    @Override
    @NotNull
    public Sequence<? extends ProjectObject> getChildren() {
        return CollectionUtils.concat(super.getChildren(), this.getLanes());
    }

    public boolean isProcessInfoLoaded(String tagName) {
        if (Str.isEmpty(this.getId())) {
            return false;
        }
        return tagName.equals("component") || "roles".equals(tagName);
    }

    public void setName(String name) {
        this.setId(name);
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.MODEL;
    }

    @Override
    public FlowNode findNodeByLabel(String nodeId) {
        return this.getNodeContainerManager().findNodeByLabel(nodeId);
    }

    @Override
    public FlowNode findNode(String activityName) {
        return this.getNodeContainerManager().findNode(activityName);
    }

    @Override
    public Gateway findGateway(String gatewayId) {
        return this.getNodeContainerManager().findGateway(gatewayId);
    }

    @Override
    public Event findEvent(String eventId) {
        return this.getNodeContainerManager().findEvent(eventId);
    }

    @Override
    public BoundaryEvent findBoundaryEvent(String eventId) {
        return this.getNodeContainerManager().findBoundaryEvent(eventId);
    }

    @Override
    public Activity findActivity(String activityId) {
        return this.getNodeContainerManager().findActivity(activityId);
    }

    @Override
    public SequenceFlow findSequenceFlow(String sequenceFlowId) {
        return this.getNodeContainerManager().findSequenceFlow(sequenceFlowId);
    }

    @Override
    public Measurement findMeasurement(String measurementId) {
        return this.getNodeContainerManager().findMeasurement(measurementId);
    }

    @Override
    public Sequence<Measurement> getMeasurements() {
        return this.getNodeContainerManager().getMeasurements();
    }

    @Override
    public Activity createActivity() {
        return this.getNodeContainerManager().createActivity();
    }

    @Override
    public Activity createActivity(boolean needLabel) {
        return this.getNodeContainerManager().createActivity(needLabel);
    }

    @Override
    public Subprocess createSubprocess() {
        return this.getNodeContainerManager().createSubprocess();
    }

    @Override
    public Subprocess createSubprocess(boolean isTriggeredByEvent) {
        return this.getNodeContainerManager().createSubprocess(isTriggeredByEvent);
    }

    @Override
    public ParallelGateway createParallelGateway() {
        return this.getNodeContainerManager().createParallelGateway();
    }

    @Override
    public InclusiveGateway createInclusiveGateway() {
        return this.getNodeContainerManager().createInclusiveGateway();
    }

    @Override
    public EventBasedGateway createEventBasedGateway() {
        return this.getNodeContainerManager().createEventBasedGateway();
    }

    @Override
    public ComplexGateway createComplexGateway() {
        return this.getNodeContainerManager().createComplexGateway();
    }

    @Override
    public ProcessSealType getSealType() {
        return (ProcessSealType)this.getFeature(ProcessSealTypeFeature.class).getValue();
    }

    @Override
    public void setSealType(ProcessSealType sealType) {
        this.getFeature(ProcessSealTypeFeature.class).setValue(sealType);
    }

    @Override
    public Sequence<BoundaryEvent> getBoundaryEvents() {
        return this.getNodeContainerManager().getBoundaryEvents();
    }

    @Override
    public ExclusiveGateway createExclusiveGateway() {
        return this.getNodeContainerManager().createExclusiveGateway();
    }

    @Override
    public ThrowEvent createIntermediateThrowEvent(EventTriggerType triggerType) {
        return this.getNodeContainerManager().createIntermediateThrowEvent(triggerType);
    }

    @Override
    public CatchEvent createIntermediateCatchEvent(EventTriggerType triggerType) {
        return this.getNodeContainerManager().createIntermediateCatchEvent(triggerType);
    }

    @Override
    public BoundaryEvent createBoundaryEvent(EventTriggerType triggerType, Activity boundaryTarget) {
        return this.getNodeContainerManager().createBoundaryEvent(triggerType, boundaryTarget);
    }

    @Override
    public StartEvent createStartEvent(EventTriggerType triggerType) {
        return this.getNodeContainerManager().createStartEvent(triggerType);
    }

    @Override
    public EndEvent createEndEvent(EventTriggerType triggerType) {
        return this.getNodeContainerManager().createEndEvent(triggerType);
    }

    @Override
    public SequenceFlow createSequenceFlow() {
        return this.getNodeContainerManager().createSequenceFlow();
    }

    @Override
    public SequenceFlow createSequenceFlow(FlowNode source, FlowNode target) {
        return this.getNodeContainerManager().createSequenceFlow(source, target);
    }

    @Deprecated
    public SequenceFlow createSequenceFlow(String sequenceFlowId, FlowNode source, FlowNode target) {
        SequenceFlow sequenceFlow = this.getNodeContainerManager().createSequenceFlow(source, target);
        sequenceFlow.setId(sequenceFlowId);
        return sequenceFlow;
    }

    @Override
    public Sequence<SequenceFlow> getSequenceFlows() {
        return this.getNodeContainerManager().getSequenceFlows();
    }

    @Override
    public Sequence<FlowNode> getFlowNodes() {
        return this.getNodeContainerManager().getFlowNodes();
    }

    @Override
    public <T extends FlowNode> Sequence<T> getFlowNodes(Class<T> clazz) {
        return this.getNodeContainerManager().getFlowNodes(clazz);
    }

    @Override
    public <T extends Activity> Sequence<T> getActivities(Class<T> clazz) {
        return this.getNodeContainerManager().getActivities(clazz);
    }

    @Override
    public Sequence<Activity> getActivities() {
        return this.getNodeContainerManager().getActivities();
    }

    @Override
    public <T extends Event> Sequence<T> getEvents(Class<T> clazz) {
        return this.getNodeContainerManager().getEvents(clazz);
    }

    @Override
    public <T extends Event> Sequence<T> getEvents(Class<T> clazz, EventTriggerType trigger) {
        return this.getNodeContainerManager().getEvents(clazz, trigger);
    }

    @Override
    public Sequence<Event> getEvents() {
        return this.getNodeContainerManager().getEvents();
    }

    @Override
    public <T extends Gateway> Sequence<T> getGateways(Class<T> clazz) {
        return this.getNodeContainerManager().getGateways(clazz);
    }

    @Override
    public Sequence<Gateway> getGateways() {
        return this.getNodeContainerManager().getGateways();
    }

    @Override
    public Measurement createMeasurement(String measurementId) {
        return this.getNodeContainerManager().createMeasurement(measurementId);
    }

    @Override
    public TextAnnotation createTextAnnotation(String idAnnotation) {
        return this.getNodeContainerManager().createTextAnnotation(idAnnotation);
    }

    @Override
    public Lane createLane(@Nullable String roleId) {
        LaneImpl lane = new LaneImpl(this);
        if (roleId != null) {
            lane.setRole(roleId);
        }
        return lane;
    }

    @Override
    public void addChild(ProjectObject child) throws ProjectException {
        if (child instanceof Lane) {
            this.addLane((Lane)child);
        } else {
            this.getNodeContainerManager().validateAddChild(child);
            super.addChild(child);
        }
    }

    @Override
    public void setMeasurementsChanged(boolean measurementsChanged) {
        this.measurementsChanged = measurementsChanged;
    }

    @Override
    public boolean isMeasurementsChanged() {
        return this.measurementsChanged;
    }

    @Override
    public void addMeasurement(Measurement measurement) throws ProjectException {
        this.addChild(measurement);
    }

    @Override
    public void removeMeasurement(Measurement measurement) throws ProjectException {
        this.removeChild(measurement);
    }

    public void addLane(Lane lane) throws ProjectException {
        this.events().preObjectAdded(lane, (ProjectObject)this);
        this.getLanesInternal().put(lane.getOffset(), lane);
        this.events().postObjectAdded(lane, (ProjectObject)this);
    }

    public void removeLane(@NotNull Lane lane) throws ProjectException {
        this.events().preObjectRemoved(lane, (ProjectObject)this);
        this.getLanesInternal().remove(lane.getOffset());
        this.events().postObjectRemoved(lane, (ProjectObject)this);
    }

    public void addNote(@NotNull TextAnnotation note) throws ProjectException {
        this.addChild(note);
    }

    public void removeNote(@NotNull TextAnnotation note) throws ProjectException {
        this.removeChild(note);
    }

    @Override
    public LocaleStringMap getDocumentationMap() {
        if (this.documentation == null) {
            this.documentation = this.createLocaleStringMap("process.documentation");
        }
        return this.documentation;
    }

    @Override
    public ProcessGenerateEvents getGeneratesEvents() {
        return (ProcessGenerateEvents)this.getFeature(ProcessGenerateEventsFeature.class).getValue();
    }

    @Override
    public void clear() {
        super.clear();
        this.getLanesInternal().clear();
    }

    public void createBeginAndEnd(boolean createBeginEnd, boolean createBeginEndTransition, boolean isCallable, boolean isSync) throws ProjectException {
        if (ModelUtils.getStartEvent(this) == null) {
            Lane lane = ModelUtils.findOrCreateAutomaticLane(this);
            lane.setSize(450);
            this.addChild(lane);
            if (createBeginEnd) {
                EventTriggerType trigger = EventTriggerType.MESSAGE;
                if (isCallable) {
                    trigger = EventTriggerType.NONE;
                }
                StartEvent begin = this.createStartEvent(trigger);
                begin.setLocation(LaneUtils.getLocationFor(lane, 0.5, 100));
                this.addChild(begin);
                EndEvent end = this.createEndEvent(trigger);
                end.setLocation(LaneUtils.getLocationFor(lane, 0.5, 200));
                this.addChild(end);
                if (createBeginEndTransition) {
                    SequenceFlow seqFlow = this.getNodeContainerManager().createSequenceFlow(begin, end);
                    this.addChild(seqFlow);
                }
                if (!this.isCallableSubprocess()) {
                    Conversation conversation = this.createDefaultConversation(ConversationType.DEFINE_INTERFACE);
                    DefineInterfaceConversationDefinition conversationDefinition = conversation.getConversationDefinition().as(DefineInterfaceConversationDefinition.class);
                    conversationDefinition.setSoapServiceExposed(true);
                    this.addChild(conversation);
                    begin.setConversation(conversation);
                    end.setConversation(conversation);
                    DefineInterfaceConversationalDefinition beginDefinition = begin.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
                    DefineInterfaceConversationalDefinition endDefinition = end.getConversationalDefinition().as(DefineInterfaceConversationalDefinition.class);
                    String defaultOperationName = ConversationalHelper.getDefaultDefinedOperationName((DefineInterfaceConversationalDefinition)beginDefinition);
                    beginDefinition.setDefinedOperationName(defaultOperationName);
                    if (isSync) {
                        endDefinition.setReplyTo(begin);
                    } else {
                        String defaultCallbackOperationName = ConversationalHelper.getDefaultDefinedOperationName((DefineInterfaceConversationalDefinition)endDefinition);
                        endDefinition.setDefinedOperationName(defaultCallbackOperationName);
                    }
                    begin.setSync(isSync);
                    end.setConversationInitiator(begin);
                }
            }
        }
    }

    public void createBeginAndEnd(boolean createBeginEnd, boolean createBeginEndTransition, EventTriggerType trigger) throws ProjectException {
        if (ModelUtils.getStartEvent(this) == null) {
            Lane lane = ModelUtils.findOrCreateAutomaticLane(this);
            lane.setSize(450);
            this.addChild(lane);
            if (createBeginEnd) {
                if (this.isCallableSubprocess()) {
                    trigger = EventTriggerType.NONE;
                }
                StartEvent begin = this.createStartEvent(trigger);
                begin.setLocation(LaneUtils.getLocationFor(lane, 0.5, 100));
                this.addChild(begin);
                EndEvent end = this.createEndEvent(trigger);
                end.setLocation(LaneUtils.getLocationFor(lane, 0.5, 200));
                this.addChild(end);
                if (createBeginEndTransition) {
                    SequenceFlow seqFlow = this.getNodeContainerManager().createSequenceFlow(begin, end);
                    this.addChild(seqFlow);
                }
            }
        }
    }

    @NotNull
    public ObjectTypeDescription createInstanceType() {
        ObjectTypeDescription type = new ObjectTypeDescription("Instance");
        type.addModifier(4096L);
        type.setProperty("javaSerialId", String.valueOf(0xFEFEFEFEL));
        type.setProperty("initAllFields", "true");
        ProjectException.addDetail((TypeDescription)type, this);
        if (this.getProject() != null) {
            int i = 1;
            String javaPackage = PublishUtils.buildCILClassName(this.getName(), this.getId(), i, 0, "");
            type.setProperty("package", javaPackage);
        }
        type.setCatalog(this.catalog);
        String prefix = "CIL_";
        type.setProperty("methodPrefix", prefix);
        type.setComponentType(ComponentType.XOBJECT.getText());
        type.addMember(type.createConstructor());
        return type;
    }

    @Override
    public Counter createCounter(String counterId) {
        return this.getNodeContainerManager().createCounter(counterId);
    }

    @Override
    public void addCounter(Counter counter) throws ProjectException {
        this.addChild(counter);
    }

    @Override
    public void removeCounter(Counter counter) throws ProjectException {
        this.removeChild(counter);
    }

    @Override
    public Counter findCounter(String counterId) {
        return this.getNodeContainerManager().findCounter(counterId);
    }

    @Override
    public Sequence<Counter> getCounters() {
        return this.getNodeContainerManager().getCounters();
    }

    public TextAnnotation createNote() {
        return new TextAnnotationImpl(this);
    }

    @Override
    public LocaleStringMap getLabelMap() {
        return this.label;
    }

    @Override
    public String getDefaultLabel() {
        return this.getString(this.getLabelMap(), this.getId());
    }

    @Override
    public String getDefaultDescription() {
        return this.getString(this.getDescriptionMap(), "");
    }

    @Override
    public String getLabel(Locale locale) {
        return this.getLabelMap().getString(locale);
    }

    public void fix() {
    }

    @Override
    public <T extends Feature> T getFeature(Class<T> clazz) {
        T feature = this.features.getFeature(clazz);
        if (feature == null) {
            feature = this.features.find(clazz);
        }
        return feature;
    }

    @Override
    public <T> T getFeatureValue(Class<? extends Feature<T>> clazz) {
        return this.features.getValue(clazz);
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    @Override
    public String getAuthor() {
        return this.getFeature(AuthorFeature.class).getValue();
    }

    @Override
    public ProjectObject getParentObject() {
        return super.getParentObject() == null ? this.container : super.getParentObject();
    }

    @Override
    public Path getPath() {
        if (this.path == null) {
            Path parentPath = this.getParentObject().getPath();
            this.path = parentPath.create(this.getId());
        }
        return this.path;
    }

    public Path getPath(boolean recalculate) {
        this.path = recalculate ? null : this.getParentObject().getPath().create(this.getId());
        return this.getPath();
    }

    @Override
    public LocaleStringMap getUseCaseDocumentationMap() {
        if (this.useCaseDocumentation == null) {
            this.useCaseDocumentation = this.createLocaleStringMap("process.useCaseDocumentation");
        }
        return this.useCaseDocumentation;
    }

    @Override
    public Localizable.Mutable asMutableLocalizable() {
        return this;
    }

    public ComponentCatalog getCatalog() {
        if (this.catalog == null) {
            this.catalog = this.getProject().getComponentCatalog();
        }
        return this.catalog;
    }

    @Override
    public LocaleStringMap getDescriptionMap() {
        if (this.description == null) {
            this.description = this.createLocaleStringMap("process.description");
        }
        return this.description;
    }

    @Override
    public Lane findLane(final @NotNull String laneId) {
        return CollectionUtils.findFirst(this.getLanes(), new Predicate<Lane>(){

            @Override
            public boolean check(@Nullable Lane value) {
                return value != null && laneId.equals(value.getId());
            }
        });
    }

    @Override
    public TextAnnotation findTextAnnotation(String noteId) {
        return this.getNodeContainerManager().findTextAnnotation(noteId);
    }

    @Override
    public Sequence<TextAnnotation> getTextAnnotations() {
        return this.getNodeContainerManager().getTextAnnotations();
    }

    public ComponentCatalog getComponentCatalog() {
        return this.catalog;
    }

    @Override
    public String getName() {
        return this.getDefaultLabel();
    }

    public String getXmlns() {
        return this.getFeature(XmlnsFeature.class).getValue();
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public void setAuthor(String name) {
        this.getFeature(AuthorFeature.class).setValue(name);
    }

    @Override
    public void setAnalyticsViewIdentifier(String viewIdentifier) {
        this.getFeature(AnalyticsViewIdentifierFeature.class).setValue(viewIdentifier);
    }

    @Override
    public String getAnalyticsViewIdentifier() {
        return this.getFeature(AnalyticsViewIdentifierFeature.class).getValue();
    }

    @Override
    public void setGeneratesEvents(ProcessGenerateEvents e) {
        this.getFeature(ProcessGenerateEventsFeature.class).setValue(e);
    }

    public void setObjectTypeDescription(ObjectTypeDescription object) {
    }

    public void setXmlns(String xmlns) {
        XmlnsFeature feature = this.getFeature(XmlnsFeature.class);
        if (feature != null) {
            feature.setValue(xmlns);
        }
    }

    public String toString() {
        return this.getId();
    }

    @Override
    @NotNull
    public Sequence<Lane> getLanes() {
        return CollectionUtils.asSequence(this.getLanesInternal().values());
    }

    @Override
    public void setLabelMap(LocaleStringMap label) {
        this.label = label;
    }

    @Override
    public void setDefaultLabel(String defaultLabel) {
        if (!Any.equals(defaultLabel, this.getDefaultLabel())) {
            this.getLabelMap().put(this.getDefaultLocale(), defaultLabel);
            this.events().objectChanged("defaultLabel", null, defaultLabel);
        }
    }

    @Override
    public void setDefaultDescription(String defaultDescription) {
        if (!Any.equals(defaultDescription, this.getDefaultDescription())) {
            this.getDescriptionMap().put(this.getDefaultLocale(), defaultDescription);
            this.events().objectChanged("defaultDescription", null, defaultDescription);
        }
    }

    @Override
    public void setDescription(LocaleStringMap map) {
        this.description = map;
    }

    @Override
    public void setDocumentation(ModificationAwareLocaleStringMap map) {
        this.documentation = map;
    }

    @Override
    public void setUseCaseDocumentation(ModificationAwareLocaleStringMap map) {
        this.useCaseDocumentation = map;
    }

    @Override
    public String getNamespace() {
        String namespace = (String)this.getFeatureValue(NamespaceFeature.class);
        if ("".equals(namespace)) {
            return "http://xmlns.oracle.com/bpmn/bpmnProcess/" + this.getId();
        }
        return namespace;
    }

    public int getFileRevision() {
        return this.getFeature(FileRevisionFeature.class).getRevision();
    }

    public String getFileVersion() {
        return this.getFeature(FileRevisionFeature.class).getVersion();
    }

    @Override
    public boolean isCallableSubprocess() {
        Sequence<StartEvent> startEventSequence = this.getEvents(StartEvent.class);
        for (StartEvent startEvent : startEventSequence) {
            if (startEvent.getEventTriggerType() != EventTriggerType.NONE) continue;
            return startEventSequence.toArray().length <= 1 && !ModelUtils.isInitiator(startEvent);
        }
        return false;
    }

    @Override
    public boolean isSuspendInstanceOnDataAssociationError() {
        return this.getFeature(SuspendInstanceOnDataAssociationErrorFeature.class).getValue();
    }

    @Override
    public void setSuspendInstanceOnDataAssociationError(boolean value) {
        this.getFeature(SuspendInstanceOnDataAssociationErrorFeature.class).setValue(value);
    }

    @Override
    public ApplicationInfo getApplicationInfo() {
        return this.findChild(ApplicationInfo.class, "ApplicationInfo");
    }

    @Override
    public void init() {
        this.clear();
        if (this.features == null) {
            this.features = FeaturesByProcess.get(this);
            this.addModificationListener(this.features);
        }
    }

    @Override
    @NotNull
    public Map<String, String> getAnnotations(boolean visible) {
        return this.getFeature(AnnotationsFeature.class).getAnnotations(visible);
    }

    @Override
    public String getAnnotationValue(@NotNull String key, boolean visible) {
        return this.getFeature(AnnotationsFeature.class).getAnnotationValue(key, visible);
    }

    @Override
    public void addAnnotation(@NotNull String key, @NotNull String value, boolean visible) {
        this.getFeature(AnnotationsFeature.class).addAnnotation(key, value, visible);
    }

    @Override
    public void removeAnnotation(@NotNull String key, boolean visible) {
        this.getFeature(AnnotationsFeature.class).removeAnnotation(key, visible);
    }

    @Override
    public Process getProcess() {
        return this;
    }

    public void setComponentCatalog(MutableComponentCatalog componentCatalog) {
        this.catalog = componentCatalog;
    }

    public void renamedMethod() {
        this.events().objectChanged();
    }

    public NavigableMap<Integer, Lane> getLanesInternal() {
        return this.lanes;
    }

    @Override
    public Sequence<DataDeclaration> getDeclarations() {
        return DataDeclarationImpl.getAllDeclarations(this);
    }

    @Override
    public <T extends DataDeclaration> T findLocalDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> T findDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getDeclarations(Class<T> type) {
        return DataDeclarationImpl.getDeclarations(this, type);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getLocalDeclarations(Class<T> type) {
        return DataDeclarationImpl.getLocalDeclarations(this, type);
    }

    @Override
    public DataDeclarationContainer getParentScope() {
        return this.getProject();
    }

    @Override
    public Sequence<DataDeclaration> getLocalDeclarations() {
        Sequence<DataDeclaration> result = (Sequence<DataDeclaration>)Cast.force(this.getNodeContainerManager().getDataObjects());
        if (!ModelUtils.isDefaultProcess(this)) {
            result = PredefinedVariablesHelper.appendPredefinedVariablesForContainer(result, this);
        }
        return result;
    }

    @Override
    public DataDeclaration findLocalDeclaration(String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, name);
    }

    @Override
    public DataDeclaration findDeclaration(String name) {
        return DataDeclarationImpl.findDeclaration(this, name);
    }

    @Override
    public Sequence<DataDeclaration> findDeclarationPath(String s) {
        return DataDeclarationImpl.findDeclarationPath(this, s);
    }

    @Override
    public boolean isMutableDeclarationContainer() {
        return true;
    }

    @Override
    public DataObject createDeclaration(String name, CatalogType type) throws ProjectException {
        return this.createDeclaration(name, type, null);
    }

    @Override
    public DataObject createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
        return this.getNodeContainerManager().createDataObject(name, type);
    }

    @Override
    public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        assert (dataDeclaration instanceof DataObject) : "DataDeclaration must be a DataObject";
        this.addChild(dataDeclaration);
    }

    @Override
    public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        assert (dataDeclaration instanceof DataObject) : "DataDeclaration must be a DataObject";
        this.removeChild(dataDeclaration);
    }

    @Override
    public void clearDeclarations() throws ProjectException {
        for (DataDeclaration declaration : this.getLocalDeclarations()) {
            this.removeDeclaration(declaration);
        }
    }

    @Override
    public DataDeclarationContainer getInputArgumentsContainer() {
        DataDeclarationContainer result = null;
        InputArgumentsFeature inputArgumentsFeature = this.getFeature(InputArgumentsFeature.class);
        if (inputArgumentsFeature != null) {
            result = inputArgumentsFeature.getCustomArgumentsContainer();
        }
        return result;
    }

    @Override
    public DataDeclarationContainer getOutputArgumentsContainer() {
        DataDeclarationContainer result = null;
        OutputArgumentsFeature outputArgumentsFeature = this.getFeature(OutputArgumentsFeature.class);
        if (outputArgumentsFeature != null) {
            result = outputArgumentsFeature.getCustomArgumentsContainer();
        }
        return result;
    }

    @Override
    public boolean isInputArgumentsEnabled() {
        return true;
    }

    @Override
    public boolean isOutputArgumentsEnabled() {
        return true;
    }

    @Override
    public DataDeclarationContainer createArgumentsContainer() {
        return new ProcessArgumentContainer(this);
    }

    @Override
    public ProjectObject copy() {
        ProcessContent processContent = (ProcessContent)super.copy();
        this.updateDocumentationMaps(this, processContent);
        this.updateDeepProcessChildrenDocumentation(this, processContent);
        return processContent;
    }

    @Override
    public int getPosition() {
        return -1;
    }

    @Override
    @NotNull
    public Sequence<CorrelationKey> getCorrelationKeys() {
        return CorrelationKeyContainerManager.getCorrelationKeys(this);
    }

    @Override
    public CorrelationKey findCorrelationKey(@NotNull String correlationKeyId) {
        return CorrelationKeyContainerManager.findCorrelationKey(this, correlationKeyId);
    }

    @Override
    @NotNull
    public CorrelationKey createCorrelationKey(@NotNull String correlationKeyId) {
        return CorrelationKeyContainerManager.createCorrelationKey(this, correlationKeyId);
    }

    @Override
    public void addCorrelationKey(@NotNull CorrelationKey correlationKey) throws ProjectException {
        CorrelationKeyContainerManager.addCorrelationKey(this, correlationKey);
    }

    @Override
    public void removeCorrelationKey(@NotNull CorrelationKey correlationKey) throws ProjectException {
        CorrelationKeyContainerManager.removeCorrelationKey((CorrelationKeyContainer)this, correlationKey);
    }

    @Override
    public void removeCorrelationKey(@NotNull String correlationKeyId) throws ProjectException {
        CorrelationKeyContainerManager.removeCorrelationKey((CorrelationKeyContainer)this, correlationKeyId);
    }

    @Override
    @NotNull
    public Sequence<CorrelationKey> getScopedCorrelationKeys() {
        return CorrelationKeyContainerManager.getScopedCorrelationKeys(this);
    }

    @Override
    public CorrelationKey findInScopedCorrelationKeys(@NotNull String correlationKeyId) {
        return CorrelationKeyContainerManager.findInScopedCorrelationKeys(this, correlationKeyId);
    }

    @Override
    public Sequence<Conversation> getLocalConversations() {
        return this.getChildrenByType(Conversation.class);
    }

    @Override
    public Conversation createNamedConversation(@NotNull String name, @NotNull ConversationType type) {
        return ConversationImpl.createNamedConversation(this, name, type);
    }

    @Override
    public Conversation createDefaultConversation(@NotNull ConversationType type) {
        return ConversationImpl.createDefaultConversation(this, type);
    }

    @Override
    public Sequence<Conversation> getConversations() {
        return ConversationalHelper.getScopedConversationsInContainer((ConversationContainer)this);
    }

    @Override
    public void addConversation(@NotNull Conversation conversation) throws ProjectException {
        this.addChild(conversation);
    }

    @Override
    public void removeConversation(@NotNull Conversation conversation) throws ProjectException {
        this.removeChild(conversation);
    }

    @Override
    public ConversationContainer getParentConversationsScope() {
        return ConversationalHelper.getParentConversationsScope((ConversationContainer)this);
    }

    @Override
    protected ProjectObjectList<ProjectObject> loadChildren() throws ProjectException {
        ProjectObjectList<ProjectObject> result = new ProjectObjectList<ProjectObject>();
        result.add(new ApplicationInfoImpl());
        return result;
    }

    private void updateDeepProcessChildrenDocumentation(NodeContainer nodeContainer, NodeContainer copiedNodeContainer) {
        for (ProjectObject child : nodeContainer.getChildrenByType(ProjectObject.class)) {
            ProjectObject copiedChild = copiedNodeContainer.findChild(child.getRawClass(), child.getId());
            if (child instanceof Localizable) {
                this.updateDocumentationMaps((Localizable)((Object)child), (Localizable)((Object)copiedChild));
            }
            if (!(child instanceof NodeContainer)) continue;
            this.updateDeepProcessChildrenDocumentation((NodeContainer)child, (NodeContainer)copiedChild);
        }
    }

    private void updateDocumentationMaps(Localizable originLocalizable, Localizable copiedLocalizable) {
        this.updateMap(originLocalizable.getDocumentationMap(), copiedLocalizable.getDocumentationMap());
        this.updateMap(originLocalizable.getUseCaseDocumentationMap(), copiedLocalizable.getUseCaseDocumentationMap());
        this.updateMap(originLocalizable.getLabelMap(), copiedLocalizable.getLabelMap());
        this.updateMap(originLocalizable.getDescriptionMap(), copiedLocalizable.getDescriptionMap());
    }

    private void updateMap(LocaleStringMap originMap, LocaleStringMap targetMap) {
        for (Locale locale : originMap.keySet()) {
            targetMap.put(locale, originMap.getString(locale));
        }
    }

    private NodeContainerManager getNodeContainerManager() {
        return this.nodeContainerManager;
    }
}

