/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.collections.Sequence;
import oracle.bpm.project.DataDeclarationImpl;
import oracle.bpm.project.DefaultDeclaration;
import oracle.bpm.project.ProjectObjectContainerImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ResourceObject;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;

public class ProcessArgumentContainer
extends ProjectObjectContainerImpl
implements DataDeclarationContainer {
    public ProcessArgumentContainer(ProjectObject parent) {
        super(parent.getProject());
        this.setParentObject(parent);
        this.events().enable();
    }

    public static ProcessArgumentContainer createFrom(DataDeclarationContainer source) {
        ProjectObject parent = source.getParentObject();
        ProcessArgumentContainer result = new ProcessArgumentContainer(parent);
        for (DataDeclaration child : source.getLocalDeclarations()) {
            try {
                DataDeclaration newChild = result.createDeclaration(child.getName(), child.getType(), DataDeclarationImpl.getAccessType(child));
                result.addDeclaration(newChild);
            }
            catch (ProjectException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public boolean isDeletable() {
        return false;
    }

    @Override
    public Sequence<DataDeclaration> getDeclarations() {
        return DataDeclarationImpl.getAllDeclarations(this);
    }

    @Override
    public DataDeclarationContainer getParentScope() {
        return null;
    }

    @Override
    public Sequence<DataDeclaration> getLocalDeclarations() {
        return this.getChildrenByType(DataDeclaration.class);
    }

    @Override
    public DataDeclaration findLocalDeclaration(String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, name);
    }

    @Override
    public DataDeclaration findDeclaration(String name) {
        return DataDeclarationImpl.findDeclaration(this, name);
    }

    @Override
    public Sequence<DataDeclaration> findDeclarationPath(String path) {
        return DataDeclarationImpl.findDeclarationPath(this, path);
    }

    @Override
    public <T extends DataDeclaration> T findLocalDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> T findDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getDeclarations(Class<T> type) {
        return DataDeclarationImpl.getDeclarations(this, type);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getLocalDeclarations(Class<T> type) {
        return DataDeclarationImpl.getLocalDeclarations(this, type);
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type) throws ProjectException {
        return this.createDeclaration(name, type, AccessType.IN);
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
        return this.createProcessArgument(name, type, accessType);
    }

    @Override
    public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        this.addChild(dataDeclaration);
    }

    @Override
    public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        this.removeChild(dataDeclaration);
    }

    @Override
    public void clearDeclarations() throws ProjectException {
        this.clear();
    }

    @Override
    public boolean isMutableDeclarationContainer() {
        return true;
    }

    @Override
    public ResourceObject findResourceObject() {
        return this.getProject();
    }

    @Override
    public Class getRawClass() {
        return ProcessArgumentContainer.class;
    }

    private DefaultDeclaration createProcessArgument(String name, CatalogType type, AccessType accessType) {
        return new DefaultDeclaration(this, name, type, accessType);
    }
}

