/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.project.ListEvent;
import oracle.bpm.project.ListListener;

public class NotifierArrayList
extends ArrayList {
    private transient List listListeners = new ArrayList();
    static final long serialVersionUID = -2950656180715566190L;
    static final long serialCheck = -8111374271616489188L;

    public NotifierArrayList() {
    }

    public NotifierArrayList(int size) {
        super(size);
    }

    @Override
    public boolean add(Object o) {
        boolean b = super.add(o);
        if (b) {
            this.fireListChange(new ListEvent(o, 0));
        }
        return b;
    }

    public void addListListener(ListListener ll) {
        if (!this.listListeners.contains(ll)) {
            this.listListeners.add(ll);
        }
    }

    @Override
    public void clear() {
        for (Object o : this) {
            this.fireListChange(new ListEvent(o, 1));
        }
        super.clear();
    }

    @Override
    public boolean remove(Object o) {
        boolean b = super.remove(o);
        if (b) {
            this.fireListChange(new ListEvent(o, 1));
        }
        return b;
    }

    @Override
    public Object remove(int index) {
        Object o = super.remove(index);
        this.fireListChange(new ListEvent(o, 1));
        return o;
    }

    public void removeListListener(ListListener ll) {
        this.listListeners.remove(ll);
    }

    protected void fireListChange(ListEvent e) {
        Iterator it = this.listListeners.iterator();
        while (it.hasNext()) {
            ((ListListener)it.next()).listChanged(e);
        }
    }
}

