/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.ActivityImpl;
import oracle.bpm.project.FeaturesByLane;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.ProcessObjectImpl;
import oracle.bpm.project.compile.exceptions.RoleNotFoundException;
import oracle.bpm.project.model.ModelObjectType;
import oracle.bpm.project.model.ModificationAwareLocaleStringMap;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.Path;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ModelException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.features.IntFeature;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.msg.ProjectMsg;
import org.jetbrains.annotations.NotNull;

public class LaneImpl
extends ProcessObjectImpl
implements Lane {
    private int backgroundColor = -1761607681;
    private ModificationAwareLocaleStringMap description;
    private Features features;
    private ModificationAwareLocaleStringMap labelMap;
    private IntFeature offset = IntFeature.create("offset", 0);
    private StringFeature roleId = StringFeature.create("roleId", "");
    private IntFeature size = IntFeature.create("size", 200);
    private static HashMap<String, String> predefinedRolesById = new HashMap();
    public static final String ALL_ROLE = "$All";
    public static int FIRST = 0;

    public LaneImpl(ProcessContent process) {
        super(process);
        this.setId(ModelUtils.generateLaneId(process));
        this.addModificationListener(this.size, this.offset, this.roleId);
        this.init();
    }

    public static String getAutomaticHandlerDisplayName() {
        return ProjectMsg.AUTOMATIC_HANDLER_ROLE.getString();
    }

    public static String getAllRoleDisplayName() {
        return ProjectMsg.ALL_ROLE.getString();
    }

    public static boolean isPredefined(String name) {
        return predefinedRolesById.get(name) != null;
    }

    @Override
    public String getDefaultLabel() {
        return this.getName();
    }

    @Override
    public String getName() {
        Role role = this.resolveRole();
        return role != null ? role.getName() : this.getRole();
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    @Override
    public <T extends Feature> T getFeature(Class<T> clazz) {
        T feature = this.features.getFeature(clazz);
        if (feature == null) {
            feature = this.features.find(clazz);
        }
        return feature;
    }

    @Override
    public <T> T getFeatureValue(Class<? extends Feature<T>> clazz) {
        return this.features.getValue(clazz);
    }

    @Override
    @NotNull
    public Sequence<FlowNode> getActivities() {
        Predicate<FlowNode> equalsLane = new Predicate<FlowNode>(){

            @Override
            public boolean check(FlowNode flowNode) {
                return flowNode.getLane() == LaneImpl.this;
            }
        };
        return this.getProcess().getFlowNodes().select(equalsLane);
    }

    public List<FlowNode> getActivityList() {
        TreeMap<String, FlowNode> map = new TreeMap<String, FlowNode>();
        FlowNodeIterator iterator = this.activities();
        while (iterator.hasNext()) {
            FlowNode activity = iterator.nextActivity();
            map.put(activity.getId(), activity);
        }
        return new ArrayList<FlowNode>(map.values());
    }

    public boolean isAll() {
        return this.getId().equals(ALL_ROLE);
    }

    public ModelObjectType getComponentType() {
        return ModelObjectType.LANE;
    }

    @Override
    public void setSize(int size) {
        this.size.setValue(size);
    }

    @Override
    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.events().objectChanged();
    }

    @Override
    public void setRole(String roleId) {
        this.roleId.setValue(roleId);
    }

    @Override
    public int getOffset() {
        return this.offset.getValue();
    }

    @Override
    public boolean isAutomatic() {
        return "AutomaticHandler".equals(this.getRole());
    }

    @Override
    public boolean isHidden() {
        return this.size.getValue() == 1;
    }

    public int getPrevSize() {
        return 200;
    }

    @Override
    public int getSize() {
        return this.size.getValue();
    }

    @Override
    public void setOffset(int newOffset) {
        NavigableMap<Integer, Lane> lanes = this.getProcessContent().getLanesInternal();
        Lane lane = (Lane)lanes.get(this.offset.getValue());
        if (lane != null && lane.equals(this)) {
            lanes.remove(this.offset.getValue());
        }
        this.offset.setValue(newOffset);
        lanes.put(newOffset, this);
    }

    public FlowNodeIterator activities() {
        return new FlowNodeIterator(false);
    }

    @Override
    public Path getPath() {
        return this.getParentObject().getPath().create(this.getId());
    }

    public void check(ProjectMessageListener listener) throws ModelException {
        if (!this.isAutomatic() && this.resolveRole() == null) {
            RoleNotFoundException e = new RoleNotFoundException((Lane)this);
            if (listener != null) {
                listener.reportError(this, (ProjectException)e);
            } else {
                throw e;
            }
        }
    }

    public boolean contains(int coordinate) {
        return coordinate >= this.getOffset() && coordinate < this.getOffset() + this.getSize();
    }

    public boolean contains(FlowNode a) {
        return this.contains(a.getX());
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    public String toString() {
        return " Name " + this.getLabelMap().getString() + " Location " + this.getOffset() + " Width " + this.getSize();
    }

    @Override
    public String getRole() {
        return this.roleId.getValue();
    }

    @Override
    public void setLabelMap(LocaleStringMap labelMap) {
        if (this.labelMap == null) {
            this.labelMap = this.createLocaleStringMap();
        }
        this.labelMap.replaceValues(labelMap);
    }

    @Override
    public LocaleStringMap getDescriptionMap() {
        if (this.description == null) {
            this.description = this.createLocaleStringMap();
        }
        return this.description;
    }

    @Override
    @NotNull
    public ProjectObjectType getProjectObjectType() {
        return ProjectObjectType.LANE;
    }

    @Override
    public Class getRawClass() {
        return Lane.class;
    }

    @Override
    protected void idChanged(String previousId) {
        if (this.getId() != null && ("0".equals(this.getId()) || this.getId().startsWith("9999"))) {
            this.setId(previousId);
        }
    }

    private void init() {
        this.features = FeaturesByLane.get(this);
        this.addModificationListener(this.features);
    }

    private Role resolveRole() {
        Organization organization;
        Role role = null;
        Project p = this.getProject();
        if (p != null && p.isOpen() && (organization = p.getOrganization()) != null) {
            role = organization.findRoleById(this.getRole());
        }
        return role;
    }

    private ModificationAwareLocaleStringMap createLocaleStringMap() {
        ModificationAwareLocaleStringMap result = new ModificationAwareLocaleStringMap(this);
        result.setString(this.getId());
        result.addModificationListener(new ModificationListener<ProjectObject>(){

            @Override
            public void objectModified(ModificationEvent<ProjectObject> event) {
                LaneImpl.this.fireObjectChanged(LaneImpl.this, ProjectEvent.CHANGE(LaneImpl.this, null, event.getOldValue(), event.getNewValue()));
            }
        });
        return result;
    }

    static {
        predefinedRolesById.put("AutomaticHandler", LaneImpl.getAutomaticHandlerDisplayName());
        predefinedRolesById.put(ALL_ROLE, LaneImpl.getAllRoleDisplayName());
    }

    public class FlowNodeIterator
    implements Iterator<FlowNode> {
        private boolean inColumn;
        private Iterator it;
        private FlowNode next;

        public FlowNodeIterator(boolean inColumn) {
            this.inColumn = inColumn;
            this.reset();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public FlowNode next() {
            return this.nextActivity();
        }

        public FlowNode nextActivity() {
            FlowNode result = this.next;
            this.advance();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void reset() {
            this.it = LaneImpl.this.getProcess().getFlowNodes().iterator();
            this.advance();
        }

        private void advance() {
            while (this.it.hasNext()) {
                ActivityImpl a = (ActivityImpl)this.it.next();
                if (a.getLane() != null && !a.getLane().getId().equals(LaneImpl.this.getId()) || this.inColumn && !LaneImpl.this.contains(a)) continue;
                this.next = a;
                return;
            }
            this.next = null;
        }
    }
}

