/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project;

import oracle.bpm.collections.Sequence;
import oracle.bpm.project.DataDeclarationImpl;
import oracle.bpm.project.DefaultDeclaration;
import oracle.bpm.project.ProjectObjectImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.AccessType;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;

public abstract class ImmutableDataDeclarationContainer
extends ProjectObjectImpl
implements DataDeclarationContainer {
    public ImmutableDataDeclarationContainer(ProjectObject parent) {
        super(parent != null ? parent.getProject() : null);
        this.setParentObject(parent);
    }

    @Override
    public Sequence<DataDeclaration> getDeclarations() {
        return DataDeclarationImpl.getAllDeclarations(this);
    }

    @Override
    public DataDeclarationContainer getParentScope() {
        return null;
    }

    @Override
    public DataDeclaration findLocalDeclaration(String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, name);
    }

    @Override
    public DataDeclaration findDeclaration(String name) {
        return DataDeclarationImpl.findDeclaration(this, name);
    }

    @Override
    public Sequence<DataDeclaration> findDeclarationPath(String path) {
        return DataDeclarationImpl.findDeclarationPath(this, path);
    }

    @Override
    public <T extends DataDeclaration> T findLocalDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findLocalDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> T findDeclaration(Class<T> type, String name) {
        return DataDeclarationImpl.findDeclaration(this, type, name);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getDeclarations(Class<T> type) {
        return DataDeclarationImpl.getDeclarations(this, type);
    }

    @Override
    public <T extends DataDeclaration> Sequence<T> getLocalDeclarations(Class<T> type) {
        return DataDeclarationImpl.getLocalDeclarations(this, type);
    }

    @Override
    public boolean isMutableDeclarationContainer() {
        return false;
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type) throws ProjectException {
        return this.createDeclaration(name, type, AccessType.IN);
    }

    @Override
    public DataDeclaration createDeclaration(String name, CatalogType type, AccessType accessType) throws ProjectException {
        return new DefaultDeclaration(this, name, type, accessType);
    }

    @Override
    public void addDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeDeclaration(DataDeclaration dataDeclaration) throws ProjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearDeclarations() throws ProjectException {
        throw new UnsupportedOperationException();
    }

    public ProjectObject getRenderableObject() {
        return null;
    }

    @Override
    public Class getRawClass() {
        return ImmutableDataDeclarationContainer.class;
    }
}

